/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.core.variants;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.AbstractResourceVariantTree;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ecf.core.RemoteShare;

final class RemoteResourceVariantTree
extends AbstractResourceVariantTree {
    private final RemoteShare share;
    private final ID ownId;
    private final ID remoteId;
    private IResource[] roots;

    public RemoteResourceVariantTree(RemoteShare share, ID ownId, ID remoteId) {
        this.share = share;
        this.ownId = ownId;
        this.remoteId = remoteId;
    }

    public void setResources(IResource[] roots) {
        this.roots = roots;
    }

    protected IResourceVariant[] fetchMembers(IResourceVariant variant, IProgressMonitor monitor) throws TeamException {
        return this.share.fetchMembers(this.ownId, this.remoteId, variant, monitor);
    }

    protected IResourceVariant fetchVariant(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        return this.share.fetchVariant(this.ownId, this.remoteId, resource, monitor);
    }

    protected boolean setVariant(IResource local, IResourceVariant remote) {
        return true;
    }

    public void flushVariants(IResource resource, int depth) {
    }

    public IResourceVariant getResourceVariant(IResource resource) throws TeamException {
        return this.share.getResourceVariant(this.ownId, this.remoteId, resource);
    }

    public boolean hasResourceVariant(IResource resource) {
        return true;
    }

    public IResource[] members(IResource resource) throws TeamException {
        if (resource.getType() == 1 || !resource.exists()) {
            return new IResource[0];
        }
        try {
            IResource[] members = ((IContainer)resource).members();
            ArrayList<IResource> nonDerivedMembers = new ArrayList<IResource>(members.length);
            int i = 0;
            while (i < members.length) {
                if (!members[i].isDerived()) {
                    nonDerivedMembers.add(members[i]);
                }
                ++i;
            }
            return nonDerivedMembers.toArray(new IResource[nonDerivedMembers.size()]);
        }
        catch (CoreException e) {
            throw new TeamException(e.getStatus());
        }
    }

    public IResource[] roots() {
        return this.roots == null ? new IResource[]{} : this.roots;
    }
}

