/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.start;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.start.IECFStart;
import org.eclipse.ecf.internal.example.collab.CollabClient;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.start.AccountStart;
import org.eclipse.ecf.internal.example.collab.start.ConnectionDetails;
import org.eclipse.ecf.internal.example.collab.start.Discovery;

public class CollabStart
implements IECFStart {
    Discovery discovery = null;

    public IStatus run(IProgressMonitor monitor) {
        try {
            AccountStart as = new AccountStart();
            as.loadConnectionDetailsFromPreferenceStore();
            Collection c = as.getConnectionDetails();
            Iterator i = c.iterator();
            while (i.hasNext()) {
                this.startConnection((ConnectionDetails)i.next());
            }
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.ecf.example.collab", 200, Messages.CollabStart_EXCEPTION_STARTING_CONNECTION, (Throwable)e);
        }
        return new Status(0, "org.eclipse.ecf.example.collab", 100, Messages.CollabStart_STATUS_OK_MESSAGE, null);
    }

    private void startConnection(ConnectionDetails details) throws Exception {
        CollabClient client = new CollabClient();
        client.createAndConnectClient(details.getContainerType(), details.getTargetURI(), details.getNickname(), details.getPassword(), (IResource)ResourcesPlugin.getWorkspace().getRoot());
    }
}

