/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.types.Timestamp;
import ch.ethz.iks.util.MathUtils;

final class TimeOffset {
    private long offset;
    private long lastUpdate;
    private int lifetime = 1;
    private int seriesLength = 8;
    private static final int INITIAL_LIFETIME = 1;
    private static final int MAX_LIFETIME = 10;
    private static final int MIN_LIFETIME = 1;
    private static final int DEFAULT_SERIES = 8;
    private static final int MAX_SERIES = 32;
    private static final int MIN_SERIES = 4;

    TimeOffset(long[] timeSerie) {
        this.update(timeSerie);
    }

    void update(long[] timeSeries) {
        int len = timeSeries.length / 2;
        long[] offsets = new long[len];
        long l = 0L;
        long h = 0L;
        int i = 0;
        while (i < len) {
            long local = timeSeries[2 * i];
            long remote = timeSeries[2 * i + 1];
            offsets[i] = local - remote;
            l += MathUtils.lower32(offsets[i]);
            h += MathUtils.higher32(offsets[i]);
            ++i;
        }
        int shift = MathUtils.log2(len);
        long mean = (h <<= 32 - shift) | (l >>>= shift);
        if (this.lastUpdate != 0L) {
            long diff;
            long stddev = (MathUtils.max(offsets) - MathUtils.min(offsets)) / 3L;
            if (stddev < 10L) {
                this.seriesLength /= 2;
            }
            if (stddev > 40L) {
                this.seriesLength *= 2;
            }
            if (stddev > 100L) {
                this.seriesLength *= 2;
            }
            if ((double)(diff = MathUtils.abs(this.offset - mean)) < 50.0 - 0.5 * (double)(this.lifetime * this.lifetime)) {
                ++this.lifetime;
            }
            if (diff > 100L) {
                --this.lifetime;
            }
            if (diff > 500L) {
                this.lifetime -= 4;
            }
            if (this.seriesLength > 32) {
                this.seriesLength = 32;
            }
            if (this.seriesLength < 4) {
                this.seriesLength = 4;
            }
            if (this.lifetime > 10) {
                this.lifetime = 10;
            }
            if (this.lifetime < 1) {
                this.lifetime = 1;
            }
        }
        this.lastUpdate = System.currentTimeMillis();
        this.offset = mean;
    }

    boolean isExpired() {
        return System.currentTimeMillis() - this.lastUpdate > (long)this.lifetime * 60000L;
    }

    int seriesLength() {
        return this.seriesLength;
    }

    Long transform(Long remoteTimestamp) {
        return new Long(remoteTimestamp + this.offset);
    }

    Timestamp transform(Timestamp timestamp) {
        return Timestamp.from(timestamp.getValue() + 1000L * this.offset);
    }
}

