/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.storage;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.internal.storage.Activator;
import org.eclipse.ecf.internal.storage.IDEntry;
import org.eclipse.ecf.internal.storage.NamespaceEntry;
import org.eclipse.ecf.storage.IIDEntry;
import org.eclipse.ecf.storage.IIDStore;
import org.eclipse.ecf.storage.IIDStoreAdapter;
import org.eclipse.ecf.storage.INamespaceEntry;
import org.eclipse.ecf.storage.INamespaceStoreAdapter;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;

public class IDStore
implements IIDStore {
    private static final String idStoreNameSegment = "/ECF/Namespace";
    private static final INamespaceEntry[] EMPTY_ARRAY = new INamespaceEntry[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private String getIDAsString(ID id) {
        IIDStoreAdapter idadapter;
        String idName;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.storage.IIDStoreAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string = idName = (idadapter = (IIDStoreAdapter)id.getAdapter((Class)clazz)) != null ? idadapter.getNameForStorage() : id.toExternalForm();
        if (idName == null || idName.equals("")) {
            return null;
        }
        return EncodingUtils.encodeSlashes((String)idName);
    }

    protected ISecurePreferences getRoot() {
        return SecurePreferencesFactory.getDefault();
    }

    protected ISecurePreferences getNamespaceRoot() {
        ISecurePreferences root = this.getRoot();
        if (root == null) {
            return null;
        }
        return root.node(idStoreNameSegment);
    }

    public IIDEntry store(ID id) {
        ISecurePreferences namespaceRoot = this.getNamespaceRoot();
        if (namespaceRoot == null) {
            return null;
        }
        INamespaceEntry namespaceEntry = this.getNamespaceEntry(id.getNamespace());
        String idAsString = this.getIDAsString(id);
        if (idAsString == null) {
            return null;
        }
        return new IDEntry(namespaceEntry.getPreferences().node(idAsString));
    }

    public INamespaceEntry[] getNamespaceEntries() {
        ISecurePreferences namespaceRoot = this.getNamespaceRoot();
        if (namespaceRoot == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<NamespaceEntry> results = new ArrayList<NamespaceEntry>();
        String[] names = namespaceRoot.childrenNames();
        int i = 0;
        while (i < names.length) {
            results.add(new NamespaceEntry(namespaceRoot.node(names[i])));
            ++i;
        }
        return results.toArray(new INamespaceEntry[0]);
    }

    public INamespaceEntry getNamespaceEntry(Namespace namespace) {
        INamespaceStoreAdapter nsadapter;
        String nsName;
        if (namespace == null) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.storage.INamespaceStoreAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string = nsName = (nsadapter = (INamespaceStoreAdapter)namespace.getAdapter((Class)clazz)) != null ? nsadapter.getNameForStorage() : namespace.getName();
        if (nsName == null) {
            return null;
        }
        ISecurePreferences namespaceRoot = this.getNamespaceRoot();
        if (namespaceRoot == null) {
            return null;
        }
        return new NamespaceEntry(namespaceRoot.node(nsName));
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
    }
}

