/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.protocol.bittorrent;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import org.eclipse.ecf.protocol.bittorrent.IHashCheckListener;
import org.eclipse.ecf.protocol.bittorrent.IPieceProgressListener;
import org.eclipse.ecf.protocol.bittorrent.ITorrentErrorListener;
import org.eclipse.ecf.protocol.bittorrent.ITorrentProgressListener;
import org.eclipse.ecf.protocol.bittorrent.ITorrentStateListener;
import org.eclipse.ecf.protocol.bittorrent.TorrentFile;
import org.eclipse.ecf.protocol.bittorrent.TorrentServer;
import org.eclipse.ecf.protocol.bittorrent.internal.net.TorrentManager;

public class Torrent {
    private final TorrentManager manager;
    private final String infoHash;

    Torrent(TorrentFile torrent, Properties properties) throws IOException {
        this.manager = new TorrentManager(torrent, properties);
        this.infoHash = torrent.getInfoHash();
    }

    void connectTo(SocketChannel channel) throws UnsupportedEncodingException {
        this.manager.connectTo(channel);
    }

    public void start() throws IOException {
        this.manager.start();
        TorrentServer.addTorrent(this.infoHash, this);
    }

    public void stop() throws IOException {
        TorrentServer.remove(this.infoHash);
        this.manager.stop();
    }

    public void remove() {
        TorrentServer.remove(this.infoHash);
        this.manager.remove();
    }

    public boolean delete() {
        TorrentServer.remove(this.infoHash);
        return this.manager.delete();
    }

    public boolean performHashCheck() {
        return this.manager.performHashCheck();
    }

    public void addTorrentStateListener(ITorrentStateListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null");
        }
        this.manager.addTorrentStateListener(listener);
    }

    public void addTorrentProgressListener(ITorrentProgressListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null");
        }
        this.manager.addTorrentProgressListener(listener);
    }

    public void addPieceProgressListener(IPieceProgressListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null");
        }
        this.manager.addPieceProgressListener(listener);
    }

    public void addHashCheckListener(IHashCheckListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null");
        }
        this.manager.addHashCheckListener(listener);
    }

    public void addTorrentErrorListener(ITorrentErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null");
        }
        this.manager.addTorrentErrorListener(listener);
    }

    public boolean removeTorrentStateListener(ITorrentStateListener listener) {
        return this.manager.removeTorrentStateListener(listener);
    }

    public boolean removeTorrentProgressListener(ITorrentProgressListener listener) {
        return this.manager.removeTorrentProgressListener(listener);
    }

    public boolean removePieceProgressListener(IPieceProgressListener listener) {
        return this.manager.removePieceProgressListener(listener);
    }

    public boolean removeHashCheckListener(IHashCheckListener listener) {
        return this.manager.removeHashCheckListener(listener);
    }

    public boolean removeTorrentErrorListener(ITorrentErrorListener listener) {
        return this.manager.removeTorrentErrorListener(listener);
    }

    public void setMaxConnections(int maxConnections) throws IllegalArgumentException {
        if (maxConnections < 0) {
            throw new IllegalArgumentException("The maximum number of connections cannot be negative");
        }
        this.manager.setMaxConnections(maxConnections);
    }

    public void setFilesToDownload(int[] downloadChoices) {
        if (downloadChoices == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        this.manager.setFilesToDownload(downloadChoices);
    }

    public long getDownloaded() {
        return this.manager.getDownloaded();
    }

    public long getUploaded() {
        return this.manager.getUploaded();
    }

    public long getRemaining() {
        return this.manager.getRemaining();
    }

    public long getDownSpeed() {
        return this.manager.getDownSpeed();
    }

    public long getUpSpeed() {
        return this.manager.getUpSpeed();
    }

    public void setMaxDownloadSpeed(long maximum) {
        this.manager.setMaxDownloadSpeed(maximum);
    }

    public void setMaxUploadSpeed(long maximum) {
        this.manager.setMaxUploadSpeed(maximum);
    }

    public long getTimeRemaining() {
        return this.manager.getTimeRemaining();
    }

    public long getDiscarded() {
        return this.manager.getDiscarded();
    }

    public int getConnectedPeers() {
        return this.manager.getConnectedPeers();
    }

    public int getSeeds() {
        return this.manager.getSeeds();
    }

    public int getPeers() {
        return this.manager.getPeers();
    }

    public TorrentFile getTorrentFile() {
        return this.manager.getTorrentFile();
    }

    public int getState() {
        return this.manager.getState();
    }
}

