/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteserviceadmin.ui.rsa.model;

import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.internal.remoteservices.ui.Messages;
import org.eclipse.ecf.remoteserviceadmin.ui.endpoint.model.EndpointPropertySource;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.AbstractRSANode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.ExceptionNode;
import org.eclipse.ecf.remoteservices.ui.util.PropertyUtils;
import org.eclipse.ui.views.properties.IPropertySource;
import org.osgi.framework.ServiceReference;

public abstract class AbstractRegistrationNode
extends AbstractRSANode {
    public static final String ERROR = Messages.AbstractRegistrationNode_ErrorName;
    private final Throwable error;

    public AbstractRegistrationNode(Throwable t, boolean showStack) {
        this.error = t;
        if (this.error != null) {
            this.addChild(new ExceptionNode(this.error, showStack));
        }
    }

    public AbstractRegistrationNode(Throwable t) {
        this(t, false);
    }

    protected Throwable getError() {
        return this.error;
    }

    protected boolean hasError() {
        return this.getError() != null;
    }

    public abstract boolean isClosed();

    protected abstract String getValidName();

    protected String getErrorName() {
        return ERROR;
    }

    protected String getClosedName() {
        return CLOSED;
    }

    public abstract ServiceReference getServiceReference();

    public String getName() {
        return this.hasError() ? this.getErrorName() : (this.isClosed() ? this.getClosedName() : this.getValidName());
    }

    @Override
    public Object getAdapter(Class adapter) {
        ServiceReference sr;
        if (adapter == IPropertySource.class && (sr = this.getServiceReference()) != null) {
            return new EndpointPropertySource(PropertyUtils.convertServicePropsToMap(sr));
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public abstract void close();
}

