/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;

public interface IPresence
extends IAdaptable,
Serializable {
    public Mode getMode();

    public Map getProperties();

    public String getStatus();

    public Type getType();

    public byte[] getPictureData();

    public static class Mode
    implements Serializable {
        private static final long serialVersionUID = 3834588811853640499L;
        private static final String AVAILABLE_NAME = "available";
        private static final String AWAY_NAME = "away";
        private static final String CHAT_NAME = "chat";
        private static final String DND_NAME = "do not disturb";
        private static final String EXTENDED_AWAY_NAME = "extended away";
        private static final String INVISIBLE_NAME = "unsubscribed";
        private final transient String name;
        public static final Mode AVAILABLE = new Mode("available");
        public static final Mode AWAY = new Mode("away");
        public static final Mode CHAT = new Mode("chat");
        public static final Mode DND = new Mode("do not disturb");
        public static final Mode EXTENDED_AWAY = new Mode("extended away");
        public static final Mode INVISIBLE = new Mode("unsubscribed");
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;
        private static final Mode[] VALUES = new Mode[]{AVAILABLE, AWAY, CHAT, DND, EXTENDED_AWAY, INVISIBLE};

        protected Mode(String name) {
            this.name = name;
        }

        public static Mode fromString(String presenceMode) {
            if (presenceMode == null) {
                return null;
            }
            if (presenceMode.equals(AVAILABLE_NAME)) {
                return AVAILABLE;
            }
            if (presenceMode.equals(AWAY_NAME)) {
                return AWAY;
            }
            if (presenceMode.equals(CHAT_NAME)) {
                return CHAT;
            }
            if (presenceMode.equals(DND_NAME)) {
                return DND;
            }
            if (presenceMode.equals(EXTENDED_AWAY_NAME)) {
                return EXTENDED_AWAY;
            }
            if (presenceMode.equals(INVISIBLE_NAME)) {
                return INVISIBLE;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public final boolean equals(Object that) {
            return super.equals(that);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        Object readResolve() throws ObjectStreamException {
            return VALUES[this.ordinal];
        }
    }

    public static class Type
    implements Serializable {
        private static final long serialVersionUID = 3546921402750743089L;
        private static final String AVAILABLE_NAME = "available";
        private static final String ERROR_NAME = "error";
        private static final String SUBSCRIBE_NAME = "subscribe";
        private static final String SUBSCRIBED_NAME = "subscribed";
        private static final String UNAVAILABLE_NAME = "unavailable";
        private static final String UNSUBSCRIBE_NAME = "unsubscribe";
        private static final String UNSUBSCRIBED_NAME = "unsubscribed";
        private static final String UNKWOWN_NAME = "unknown";
        private final transient String name;
        public static final Type AVAILABLE = new Type("available");
        public static final Type ERROR = new Type("error");
        public static final Type SUBSCRIBE = new Type("subscribe");
        public static final Type SUBSCRIBED = new Type("subscribed");
        public static final Type UNAVAILABLE = new Type("unavailable");
        public static final Type UNSUBSCRIBE = new Type("unsubscribe");
        public static final Type UNSUBSCRIBED = new Type("unsubscribed");
        public static final Type UNKNOWN = new Type("unknown");
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;
        private static final Type[] VALUES = new Type[]{AVAILABLE, ERROR, SUBSCRIBE, SUBSCRIBED, UNAVAILABLE, UNSUBSCRIBE, UNSUBSCRIBED, UNKNOWN};

        protected Type(String name) {
            this.name = name;
        }

        public static Type fromString(String presenceType) {
            if (presenceType == null) {
                return null;
            }
            if (presenceType.equals(AVAILABLE_NAME)) {
                return AVAILABLE;
            }
            if (presenceType.equals(ERROR_NAME)) {
                return ERROR;
            }
            if (presenceType.equals(SUBSCRIBE_NAME)) {
                return SUBSCRIBE;
            }
            if (presenceType.equals(SUBSCRIBED_NAME)) {
                return SUBSCRIBED;
            }
            if (presenceType.equals(UNAVAILABLE_NAME)) {
                return UNAVAILABLE;
            }
            if (presenceType.equals(UNSUBSCRIBE_NAME)) {
                return UNSUBSCRIBE;
            }
            if (presenceType.equals(UNSUBSCRIBED_NAME)) {
                return UNSUBSCRIBED;
            }
            if (presenceType.equals(UNKWOWN_NAME)) {
                return UNKNOWN;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public final boolean equals(Object that) {
            return super.equals(that);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        Object readResolve() throws ObjectStreamException {
            return VALUES[this.ordinal];
        }
    }
}

