/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.GUID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.LongID;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.identity.URIID;
import org.eclipse.ecf.core.provider.ContainerInstantiatorUtils;
import org.eclipse.ecf.core.provider.ContainerIntentException;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.provider.IRemoteServiceContainerInstantiator;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.ProviderPlugin;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.SSLClientSOContainer;
import org.eclipse.ecf.provider.generic.SSLServerSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;

public class SSLGenericContainerInstantiator
implements IContainerInstantiator,
IRemoteServiceContainerInstantiator {
    protected static final String[] genericProviderIntents = new String[]{"osgi.basic", "osgi.async", "osgi.private", "passByValue", "exactlyOnce", "ordered"};
    public static final String SSLCLIENT_NAME = "ecf.generic.ssl.client";
    public static final String SSLSERVER_NAME = "ecf.generic.ssl.server";
    private static final int CREATE_INSTANCE_ERROR_CODE = 4441;
    private static final String ID_PROP = "id";
    private static final String KEEPALIVE_PROP = "keepAlive";
    private static final String HOSTNAME_PROP = "hostname";
    private static final String PORT_PROP = "port";
    private static final String PATH_PROP = "path";
    private static final String BINDADDRESS_PROP = "bindAddress";
    private static final String NEEDCLIENTAUTH_PROP = "needClientAuth";
    private static final String WANTCLIENTAUTH_PROP = "wantClientAuth";

    protected ID getIDFromArg(Object arg) throws IDCreateException {
        if (arg == null) {
            throw new IDCreateException("id cannot be null");
        }
        String val = null;
        if (arg instanceof StringID) {
            return (ID)arg;
        }
        if (arg instanceof GUID) {
            val = ((GUID)arg).getName();
        } else if (arg instanceof URIID) {
            val = ((URIID)arg).toURI().toString();
        } else if (arg instanceof LongID) {
            val = ((LongID)arg).getName();
        }
        if (arg instanceof String) {
            val = (String)arg;
        }
        if (arg instanceof Integer) {
            val = IDFactory.getDefault().createGUID(((Integer)arg).intValue()).getName();
        }
        if (val == null) {
            val = IDFactory.getDefault().createGUID().getName();
        }
        return IDFactory.getDefault().createStringID(val);
    }

    protected Integer getIntegerFromArg(Object arg) {
        if (arg == null) {
            return new Integer(-1);
        }
        if (arg instanceof Integer) {
            return (Integer)arg;
        }
        if (arg instanceof String) {
            return new Integer((String)arg);
        }
        return new Integer(-1);
    }

    protected GenericContainerArgs getClientArgs(Object[] args) throws IDCreateException {
        ID newID = null;
        Integer ka = null;
        if (args != null && args.length > 0) {
            if (args[0] instanceof Map) {
                Map map = (Map)args[0];
                Object idVal = map.get(ID_PROP);
                if (idVal == null) {
                    throw new IDCreateException("Cannot create ID.  No property with key=id found in configuration=" + map);
                }
                newID = this.getIDFromArg(idVal);
                ka = this.getIntegerFromArg(map.get(KEEPALIVE_PROP));
            } else if (args.length > 1) {
                if (args[0] instanceof String || args[0] instanceof ID) {
                    newID = this.getIDFromArg(args[0]);
                }
                if (args[1] instanceof String || args[1] instanceof Integer) {
                    ka = this.getIntegerFromArg(args[1]);
                }
            } else {
                newID = this.getIDFromArg(args[0]);
            }
        }
        if (newID == null) {
            newID = IDFactory.getDefault().createStringID(IDFactory.getDefault().createGUID().getName());
        }
        if (ka == null) {
            ka = new Integer(0);
        }
        return new GenericContainerArgs(newID, ka);
    }

    protected boolean isClient(ContainerTypeDescription description) {
        return !description.getName().equals(SSLSERVER_NAME);
    }

    protected GenericContainerArgs getServerArgs(Object[] args) throws IDCreateException, ContainerIntentException {
        ID newID = null;
        Integer ka = null;
        InetAddress bindAddress = null;
        boolean wantClientAuth = false;
        boolean needClientAuth = false;
        boolean privateIntent = false;
        if (args != null && args.length > 0) {
            if (args[0] instanceof Map) {
                Object wantClientAuthVal;
                Object o;
                Map map = (Map)args[0];
                Object idVal = map.get(ID_PROP);
                if (idVal != null) {
                    newID = this.getIDFromArg(idVal);
                } else {
                    String hostname = SSLServerSOContainer.DEFAULT_HOST;
                    Object hostVal = map.get(HOSTNAME_PROP);
                    if (hostVal != null) {
                        if (!(hostVal instanceof String)) {
                            throw new IllegalArgumentException("hostname value must be of type String");
                        }
                        hostname = (String)hostVal;
                    }
                    int port = -1;
                    Object portVal = map.get(PORT_PROP);
                    if (portVal != null) {
                        port = this.getIntegerFromArg(portVal);
                    }
                    if (port < 0) {
                        port = this.getSSLServerPort(port);
                    }
                    String path = SSLServerSOContainer.DEFAULT_NAME;
                    Object pathVal = map.get(PATH_PROP);
                    if (pathVal != null) {
                        if (!(pathVal instanceof String)) {
                            throw new IllegalArgumentException("path value must be of type String");
                        }
                        path = (String)pathVal;
                    }
                    newID = this.createSSLServerID(hostname, port, path);
                }
                Object bindAddressVal = map.get(BINDADDRESS_PROP);
                if (bindAddressVal != null) {
                    if (bindAddressVal instanceof InetAddress) {
                        bindAddress = (InetAddress)bindAddressVal;
                    } else {
                        throw new IllegalArgumentException("bindAddress must be of type InetAddress");
                    }
                }
                if ((o = map.get(KEEPALIVE_PROP)) == null) {
                    o = map.get(KEEPALIVE_PROP.toLowerCase());
                }
                ka = this.getIntegerFromArg(o);
                Object needClientAuthVal = map.get(NEEDCLIENTAUTH_PROP);
                if (needClientAuthVal instanceof Boolean) {
                    needClientAuth = (Boolean)needClientAuthVal;
                }
                if ((wantClientAuthVal = map.get(WANTCLIENTAUTH_PROP)) instanceof Boolean) {
                    wantClientAuth = (Boolean)wantClientAuthVal;
                }
                privateIntent = ContainerInstantiatorUtils.containsPrivateIntent((Map)map);
            } else if (args.length > 1) {
                if (args[0] instanceof String || args[0] instanceof ID) {
                    newID = this.getIDFromArg(args[0]);
                }
                if (args[1] instanceof String || args[1] instanceof Integer) {
                    ka = this.getIntegerFromArg(args[1]);
                }
            } else {
                newID = this.getIDFromArg(args[0]);
            }
        }
        if (newID == null) {
            int port = -1;
            if (SSLServerSOContainer.DEFAULT_FALLBACK_PORT) {
                port = this.getFreePort();
            } else if (this.portIsFree(SSLServerSOContainer.DEFAULT_PORT)) {
                port = SSLServerSOContainer.DEFAULT_PORT;
            }
            if (port < 0) {
                throw new IDCreateException("No server port is available for generic server creation.  org.eclipse.ecf.provider.generic.secure.port.fallback=" + SSLServerSOContainer.DEFAULT_FALLBACK_PORT + " and org.eclipse.ecf.provider.generic.secure.port=" + SSLServerSOContainer.DEFAULT_PORT);
            }
            newID = IDFactory.getDefault().createStringID("ecfssl://" + SSLServerSOContainer.DEFAULT_HOST + ":" + port + SSLServerSOContainer.DEFAULT_NAME);
        }
        if (ka == null) {
            ka = new Integer(SSLServerSOContainer.DEFAULT_KEEPALIVE);
        }
        if (privateIntent) {
            ContainerInstantiatorUtils.checkPrivate(newID);
        }
        return new GenericContainerArgs(newID, ka, bindAddress, wantClientAuth, needClientAuth);
    }

    private ID createSSLServerID(String hostname, int port, String path) {
        return IDFactory.getDefault().createStringID("ecfssl://" + hostname + ":" + port + path);
    }

    private int getSSLServerPort(int input) {
        if (SSLServerSOContainer.DEFAULT_FALLBACK_PORT) {
            input = this.getFreePort();
        } else if (this.portIsFree(SSLServerSOContainer.DEFAULT_PORT)) {
            input = SSLServerSOContainer.DEFAULT_PORT;
        }
        if (input < 0) {
            throw new IDCreateException("No server port is available for generic secure server creation.  org.eclipse.ecf.provider.generic.port.fallback=" + TCPServerSOContainer.DEFAULT_FALLBACK_PORT + " and org.eclipse.ecf.provider.generic.port=" + TCPServerSOContainer.DEFAULT_PORT);
        }
        return input;
    }

    private SSLServerSocketFactory getServerSocketFactory() {
        return ProviderPlugin.getDefault().getSSLServerSocketFactory();
    }

    private boolean portIsFree(int port) {
        ServerSocket ss = null;
        try {
            try {
                ss = this.getServerSocketFactory().createServerSocket(port);
                ss.close();
            }
            catch (BindException e) {
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException e2) {
                        throw new IDCreateException((Throwable)e2);
                    }
                }
                return false;
            }
            catch (IOException e) {
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException e3) {
                        throw new IDCreateException((Throwable)e3);
                    }
                }
                return false;
            }
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    throw new IDCreateException((Throwable)e);
                }
            }
        }
        return true;
    }

    private int getFreePort() {
        int port = -1;
        try {
            ServerSocket ss = this.getServerSocketFactory().createServerSocket(port);
            port = ss.getLocalPort();
            ss.close();
        }
        catch (IOException e) {
            return -1;
        }
        return port;
    }

    protected IContainer createClientContainer(GenericContainerArgs gcargs) throws Exception {
        return new SSLClientSOContainer(new SOContainerConfig(gcargs.getID()), gcargs.getKeepAlive());
    }

    protected SSLServerSocket createSSLServerSocket(int port, InetAddress inetAddress) throws IOException {
        SSLServerSocketFactory socketFactory = ProviderPlugin.getDefault().getSSLServerSocketFactory();
        if (socketFactory == null) {
            throw new IOException("Cannot get SSLServerSocketFactory to create SSLServerSocket");
        }
        return (SSLServerSocket)(inetAddress == null ? socketFactory.createServerSocket(port, 50) : socketFactory.createServerSocket(port, 50, inetAddress));
    }

    protected IContainer createServerContainer(GenericContainerArgs gcargs) throws Exception {
        SOContainerConfig config = new SOContainerConfig(gcargs.getID());
        ID id = gcargs.getID();
        URI uri = URI.create(id.getName());
        SSLServerSocket serverSocket = this.createSSLServerSocket(uri.getPort(), gcargs.getBindAddress());
        if (gcargs.getClientAuth()) {
            if (gcargs.getNeedClientAuth()) {
                serverSocket.setNeedClientAuth(true);
            } else if (gcargs.getWantClientAuth()) {
                serverSocket.setWantClientAuth(true);
            }
        }
        return new SSLServerSOContainer((ISharedObjectContainerConfig)config, serverSocket, (int)gcargs.getKeepAlive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContainer createInstance(ContainerTypeDescription description, Object[] args) throws ContainerCreateException {
        boolean isClient = this.isClient(description);
        try {
            GenericContainerArgs gcargs = null;
            if (isClient) {
                gcargs = this.getClientArgs(args);
                return this.createClientContainer(gcargs);
            }
            SSLGenericContainerInstantiator sSLGenericContainerInstantiator = this;
            synchronized (sSLGenericContainerInstantiator) {
                gcargs = this.getServerArgs(args);
                return this.createServerContainer(gcargs);
            }
        }
        catch (Exception e) {
            Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", this.getClass(), (String)"createInstance", (Throwable)e);
            ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", 4441, "createInstance", (Throwable)e));
            Trace.throwing((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/throwing", this.getClass(), (String)"createInstance", (Throwable)e);
            throw new ContainerCreateException("Create of containerType=" + description.getName() + " failed.", (Throwable)e);
        }
    }

    protected Set getAdaptersForClass(Class clazz) {
        HashSet<String> result = new HashSet<String>();
        IAdapterManager adapterManager = ProviderPlugin.getDefault().getAdapterManager();
        if (adapterManager != null) {
            result.addAll(Arrays.asList(adapterManager.computeAdapterTypes(clazz)));
        }
        return result;
    }

    protected Set getInterfacesForClass(Set s, Class clazz) {
        if (clazz.equals(Object.class)) {
            return s;
        }
        s.addAll(this.getInterfacesForClass(s, clazz.getSuperclass()));
        s.addAll(Arrays.asList(clazz.getInterfaces()));
        return s;
    }

    protected Set getInterfacesForClass(Class clazz) {
        Set clazzes = this.getInterfacesForClass(new HashSet(), clazz);
        HashSet<String> result = new HashSet<String>();
        Iterator i = clazzes.iterator();
        while (i.hasNext()) {
            result.add(((Class)i.next()).getName());
        }
        return result;
    }

    protected String[] getInterfacesAndAdaptersForClass(Class clazz) {
        Set result = this.getAdaptersForClass(clazz);
        result.addAll(this.getInterfacesForClass(clazz));
        return result.toArray(new String[0]);
    }

    public String[] getSupportedAdapterTypes(ContainerTypeDescription description) {
        if (!this.isClient(description)) {
            return this.getInterfacesAndAdaptersForClass(SSLServerSOContainer.class);
        }
        return this.getInterfacesAndAdaptersForClass(SSLClientSOContainer.class);
    }

    public Class[][] getSupportedParameterTypes(ContainerTypeDescription description) {
        if (!this.isClient(description)) {
            return new Class[][]{{ID.class}, {ID.class, Integer.class}};
        }
        return new Class[][]{new Class[0], {ID.class}, {ID.class, Integer.class}};
    }

    public String[] getSupportedIntents(ContainerTypeDescription description) {
        return genericProviderIntents;
    }

    public String[] getSupportedConfigs(ContainerTypeDescription description) {
        return new String[]{description.getName()};
    }

    public String[] getImportedConfigs(ContainerTypeDescription description, String[] exporterSupportedConfigs) {
        if (exporterSupportedConfigs == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        List<String> supportedConfigs = Arrays.asList(exporterSupportedConfigs);
        if (SSLSERVER_NAME.equals(description.getName())) {
            if (supportedConfigs.contains(SSLCLIENT_NAME)) {
                results.add(SSLSERVER_NAME);
            }
        } else if (SSLCLIENT_NAME.equals(description.getName()) && (supportedConfigs.contains(SSLSERVER_NAME) || supportedConfigs.contains(SSLCLIENT_NAME))) {
            results.add(SSLCLIENT_NAME);
        }
        if (results.size() == 0) {
            return null;
        }
        return results.toArray(new String[0]);
    }

    public Dictionary getPropertiesForImportedConfigs(ContainerTypeDescription description, String[] importedConfigs, Dictionary exportedProperties) {
        return null;
    }

    protected class GenericContainerArgs {
        ID id;
        Integer keepAlive;
        InetAddress bindAddress;
        boolean wantClientAuth;
        boolean needClientAuth;

        public GenericContainerArgs(ID id, Integer keepAlive) {
            this(id, keepAlive, null);
        }

        public GenericContainerArgs(ID id, Integer keepAlive, InetAddress bindAddress) {
            this.id = id;
            this.keepAlive = keepAlive;
            this.bindAddress = bindAddress;
        }

        public GenericContainerArgs(ID id, Integer keepAlive, InetAddress bindAddress, boolean wantClientAuth, boolean needClientAuth) {
            this.id = id;
            this.keepAlive = keepAlive;
            this.bindAddress = bindAddress;
            this.wantClientAuth = wantClientAuth;
            this.needClientAuth = needClientAuth;
        }

        public ID getID() {
            return this.id;
        }

        public Integer getKeepAlive() {
            return this.keepAlive;
        }

        public InetAddress getBindAddress() {
            return this.bindAddress;
        }

        public boolean getWantClientAuth() {
            return this.wantClientAuth;
        }

        public boolean getNeedClientAuth() {
            return this.needClientAuth;
        }

        public boolean getClientAuth() {
            return this.getNeedClientAuth() | this.getWantClientAuth();
        }
    }
}

