/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.ecf.example.collab.share.io.StreamSender;

public class SharedObjectOutputStream
extends OutputStream {
    public static final int DEFAULT_BUFF_SIZE = 900;
    public static final boolean DEFAULT_COMPRESSION = true;
    protected StreamSender sender;
    protected ByteArrayOutputStream outputStream;
    protected GZIPOutputStream compressor;
    protected int defaultLength;
    protected int bytesSentCount = 0;
    protected boolean useCompression;

    public SharedObjectOutputStream(StreamSender sender, int size, boolean compression) throws IOException {
        this.sender = sender;
        this.defaultLength = size;
        this.useCompression = compression;
        this.resetStreams();
    }

    public SharedObjectOutputStream(StreamSender obj) throws IOException {
        this(obj, 900, true);
    }

    public SharedObjectOutputStream(StreamSender obj, int size) throws IOException {
        this(obj, size, true);
    }

    public SharedObjectOutputStream(StreamSender obj, boolean compression) throws IOException {
        this(obj, 900, compression);
    }

    protected void resetStreams() throws IOException {
        this.outputStream = new ByteArrayOutputStream(this.defaultLength);
        if (this.useCompression) {
            this.compressor = new GZIPOutputStream(this.outputStream);
        }
    }

    public void close() throws IOException {
        if (this.useCompression) {
            this.compressor.close();
        } else {
            this.outputStream.close();
        }
    }

    public void flush() throws IOException {
        this.sendMsgAndResetStream();
    }

    protected final void sendMsgAndResetStream() throws IOException {
        if (this.useCompression) {
            this.compressor.flush();
            this.compressor.finish();
        } else {
            this.outputStream.flush();
        }
        this.sender.sendDataMsg(this.bytesSentCount, this.outputStream.toByteArray());
        this.resetStreams();
        this.bytesSentCount = 0;
    }

    public void write(int a) throws IOException {
        if (this.bytesSentCount >= this.defaultLength) {
            this.sendMsgAndResetStream();
        }
        ++this.bytesSentCount;
        this.streamWrite(a);
    }

    protected void streamWrite(int a) throws IOException {
        if (this.useCompression) {
            this.compressor.write(a);
        } else {
            this.outputStream.write(a);
        }
    }
}

