/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;

public class GetItemsRequest
extends NodeExtension {
    protected String subId;
    protected int maxItems;

    public GetItemsRequest(String nodeId) {
        super(PubSubElementType.ITEMS, nodeId);
    }

    public GetItemsRequest(String nodeId, String subscriptionId) {
        super(PubSubElementType.ITEMS, nodeId);
        this.subId = subscriptionId;
    }

    public GetItemsRequest(String nodeId, int maxItemsToReturn) {
        super(PubSubElementType.ITEMS, nodeId);
        this.maxItems = maxItemsToReturn;
    }

    public GetItemsRequest(String nodeId, String subscriptionId, int maxItemsToReturn) {
        this(nodeId, maxItemsToReturn);
        this.subId = subscriptionId;
    }

    public String getSubscriptionId() {
        return this.subId;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public String toXML() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.getElementName());
        builder.append(" node='");
        builder.append(this.getNode());
        builder.append("'");
        if (this.getSubscriptionId() != null) {
            builder.append(" subid='");
            builder.append(this.getSubscriptionId());
            builder.append("'");
        }
        if (this.getMaxItems() > 0) {
            builder.append(" max_items='");
            builder.append(this.getMaxItems());
            builder.append("'");
        }
        builder.append("/>");
        return builder.toString();
    }
}

