/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share.io;

import java.io.File;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.example.collab.share.io.EclipseFileTransfer;
import org.eclipse.ecf.example.collab.share.io.FileTransferSharedObject;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.ui.MessageLoader;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

public class EclipseFileTransferAndLaunch
extends EclipseFileTransfer {
    private static final long serialVersionUID = -7524767418102487435L;

    public void sendDone(FileTransferSharedObject obj, Exception e) {
        if (this.senderUI != null) {
            this.senderUI.sendDone(this.transferParams.getRemoteFile(), e);
        }
        if (e == null) {
            String senderPath = ((EclipseCollabSharedObject)this.getContext().getSharedObjectManager().getSharedObject(this.sharedObjectID)).getLocalFullDownloadPath();
            this.launchFile(new File(new File(senderPath), this.transferParams.getRemoteFile().getName()).getAbsolutePath());
        }
    }

    private void launchFile(String fileName) {
        try {
            Program.launch((String)fileName);
        }
        catch (IllegalArgumentException e1) {
            ClientPlugin.log(MessageLoader.getFormattedString("EclipseFileTransferAndLaunch.EXCEPTION_LAUNCHING", this.localFile), e1);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation(null, (String)MessageLoader.getString("EclipseFileTransferAndLaunch.PROGRAM_LAUNCH_MSGBOX_TITLE"), (String)NLS.bind((String)MessageLoader.getString("EclipseFileTransferAndLaunch.PROGRAM_LAUNCH_MSGBOX_TEXT"), (Object)EclipseFileTransferAndLaunch.this.localFile.getAbsolutePath(), (Object)e1.getMessage()));
                }
            });
        }
    }

    public void receiveDone(FileTransferSharedObject obj, Exception e) {
        if (this.receiverUI != null) {
            this.receiverUI.receiveDone(this.getHomeContainerID(), this.localFile, e);
        }
        if (e == null && this.localFile != null) {
            this.launchFile(this.localFile.getAbsolutePath());
        }
    }
}

