/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jivesoftware.smack.util.StringEncoder;

public class Base32Encoder
implements StringEncoder {
    private static Base32Encoder instance = new Base32Encoder();
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ2345678";

    private Base32Encoder() {
    }

    public static Base32Encoder getInstance() {
        return instance;
    }

    public String decode(String str) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        byte[] raw = str.getBytes();
        int i = 0;
        while (i < raw.length) {
            char c = (char)raw[i];
            if (!Character.isWhitespace(c)) {
                c = Character.toUpperCase(c);
                bs.write((byte)c);
            }
            ++i;
        }
        while (bs.size() % 8 != 0) {
            bs.write(56);
        }
        byte[] in = bs.toByteArray();
        bs.reset();
        DataOutputStream ds = new DataOutputStream(bs);
        int i2 = 0;
        while (i2 < in.length / 8) {
            short[] s = new short[8];
            int[] t = new int[5];
            int padlen = 8;
            int j = 0;
            while (j < 8) {
                char c = (char)in[i2 * 8 + j];
                if (c == '8') break;
                s[j] = (short)ALPHABET.indexOf(in[i2 * 8 + j]);
                if (s[j] < 0) {
                    return null;
                }
                --padlen;
                ++j;
            }
            int blocklen = Base32Encoder.paddingToLen(padlen);
            if (blocklen < 0) {
                return null;
            }
            t[0] = s[0] << 3 | s[1] >> 2;
            t[1] = (s[1] & 3) << 6 | s[2] << 1 | s[3] >> 4;
            t[2] = (s[3] & 0xF) << 4 | s[4] >> 1 & 0xF;
            t[3] = s[4] << 7 | s[5] << 2 | s[6] >> 3;
            t[4] = (s[6] & 7) << 5 | s[7];
            try {
                int j2 = 0;
                while (j2 < blocklen) {
                    ds.writeByte((byte)(t[j2] & 0xFF));
                    ++j2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i2;
        }
        return new String(bs.toByteArray());
    }

    public String encode(String str) {
        byte[] b = str.getBytes();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int i = 0;
        while (i < (b.length + 4) / 5) {
            short[] s = new short[5];
            int[] t = new int[8];
            int blocklen = 5;
            int j = 0;
            while (j < 5) {
                if (i * 5 + j < b.length) {
                    s[j] = (short)(b[i * 5 + j] & 0xFF);
                } else {
                    s[j] = 0;
                    --blocklen;
                }
                ++j;
            }
            int padlen = Base32Encoder.lenToPadding(blocklen);
            t[0] = (byte)(s[0] >> 3 & 0x1F);
            t[1] = (byte)((s[0] & 7) << 2 | s[1] >> 6 & 3);
            t[2] = (byte)(s[1] >> 1 & 0x1F);
            t[3] = (byte)((s[1] & 1) << 4 | s[2] >> 4 & 0xF);
            t[4] = (byte)((s[2] & 0xF) << 1 | s[3] >> 7 & 1);
            t[5] = (byte)(s[3] >> 2 & 0x1F);
            t[6] = (byte)((s[3] & 3) << 3 | s[4] >> 5 & 7);
            t[7] = (byte)(s[4] & 0x1F);
            int j2 = 0;
            while (j2 < t.length - padlen) {
                char c = ALPHABET.charAt(t[j2]);
                os.write(c);
                ++j2;
            }
            ++i;
        }
        return new String(os.toByteArray());
    }

    private static int lenToPadding(int blocklen) {
        switch (blocklen) {
            case 1: {
                return 6;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    private static int paddingToLen(int padlen) {
        switch (padlen) {
            case 6: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 0: {
                return 5;
            }
        }
        return -1;
    }
}

