/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.command.CommandSupport;
import org.apache.hc.core5.http2.impl.nio.ClientH2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ClientHttpProtocolNegotiator;
import org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Timeout;

@Internal
public class H2OnlyClientProtocolNegotiator
implements HttpConnectionEventHandler {
    private final ProtocolIOSession ioSession;
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final boolean strictALPNHandshake;
    private final ByteBuffer preface;

    public H2OnlyClientProtocolNegotiator(ProtocolIOSession ioSession, ClientH2StreamMultiplexerFactory http2StreamHandlerFactory, boolean strictALPNHandshake) {
        this.ioSession = (ProtocolIOSession)Args.notNull((Object)ioSession, (String)"I/O session");
        this.http2StreamHandlerFactory = (ClientH2StreamMultiplexerFactory)Args.notNull((Object)http2StreamHandlerFactory, (String)"HTTP/2 stream handler factory");
        this.strictALPNHandshake = strictALPNHandshake;
        this.preface = ByteBuffer.wrap(ClientHttpProtocolNegotiator.PREFACE);
    }

    public void connected(IOSession session) {
        try {
            TlsDetails tlsDetails = this.ioSession.getTlsDetails();
            if (tlsDetails != null) {
                String applicationProtocol = tlsDetails.getApplicationProtocol();
                if (TextUtils.isEmpty((CharSequence)applicationProtocol)) {
                    if (this.strictALPNHandshake) {
                        throw new HttpException("ALPN: missing application protocol");
                    }
                } else if (!ApplicationProtocol.HTTP_2.id.equals(applicationProtocol)) {
                    throw new HttpException("ALPN: unexpected application protocol '" + applicationProtocol + "'");
                }
            }
            this.writePreface(session);
        }
        catch (Exception ex) {
            session.close(CloseMode.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    private void writePreface(IOSession session) throws IOException {
        if (this.preface.hasRemaining()) {
            IOSession channel = session;
            channel.write(this.preface);
        }
        if (!this.preface.hasRemaining()) {
            ClientH2StreamMultiplexer streamMultiplexer = this.http2StreamHandlerFactory.create(this.ioSession);
            ClientH2IOEventHandler newHandler = new ClientH2IOEventHandler(streamMultiplexer);
            newHandler.connected(session);
            this.ioSession.upgrade((IOEventHandler)newHandler);
        }
    }

    public void inputReady(IOSession session, ByteBuffer src) {
        this.outputReady(session);
    }

    public void outputReady(IOSession session) {
        try {
            if (this.preface != null) {
                this.writePreface(session);
            } else {
                session.close(CloseMode.GRACEFUL);
            }
        }
        catch (IOException ex) {
            session.close(CloseMode.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    public void timeout(IOSession session, Timeout timeout) {
        this.exception(session, SocketTimeoutExceptionFactory.create((Timeout)timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(IOSession session, Exception cause) {
        try {
            CommandSupport.failCommands((IOSession)session, (Exception)cause);
        }
        finally {
            session.close(CloseMode.IMMEDIATE);
        }
    }

    public void disconnected(IOSession session) {
        CommandSupport.cancelCommands((IOSession)session);
    }

    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    public EndpointDetails getEndpointDetails() {
        return null;
    }

    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    public ProtocolVersion getProtocolVersion() {
        return null;
    }

    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    public boolean isOpen() {
        return this.ioSession.isOpen();
    }

    public void close() throws IOException {
        this.ioSession.close();
    }

    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }
}

