/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.win;

import java.util.Locale;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.win.WindowsNTLMSchemeFactory;
import org.apache.hc.client5.http.impl.win.WindowsNegotiateSchemeFactory;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;

public class WinHttpClients {
    private WinHttpClients() {
    }

    public static boolean isWinAuthAvailable() {
        String os = System.getProperty("os.name");
        String string = os = os != null ? os.toLowerCase(Locale.ROOT) : null;
        if (os != null && os.contains("windows")) {
            try {
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        }
        return false;
    }

    private static HttpClientBuilder createBuilder() {
        if (WinHttpClients.isWinAuthAvailable()) {
            Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)BasicSchemeFactory.INSTANCE).register("Digest", (Object)DigestSchemeFactory.INSTANCE).register("NTLM", (Object)WindowsNTLMSchemeFactory.DEFAULT).register("Negotiate", (Object)WindowsNegotiateSchemeFactory.DEFAULT).build();
            return HttpClientBuilder.create().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        }
        return HttpClientBuilder.create();
    }

    public static HttpClientBuilder custom() {
        return WinHttpClients.createBuilder();
    }

    public static CloseableHttpClient createDefault() {
        return WinHttpClients.createBuilder().build();
    }

    public static CloseableHttpClient createSystem() {
        return WinHttpClients.createBuilder().useSystemProperties().build();
    }
}

