/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.internal.ui.Activator;
import org.eclipse.ecf.internal.ui.Messages;
import org.eclipse.ecf.internal.ui.wizards.IWizardRegistryConstants;
import org.eclipse.ecf.ui.IConfigurationWizard;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class SelectProviderAction
implements IWizardRegistryConstants,
IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate,
IViewActionDelegate {
    private IWorkbenchWindow window;
    private Menu menu;
    private HashMap map = new HashMap();
    private List elements = new ArrayList();
    private IExtension[] configurationWizards;

    public SelectProviderAction() {
        try {
            IExtensionRegistry registry = Activator.getDefault().getExtensionRegistry();
            if (registry != null) {
                this.configurationWizards = registry.getExtensionPoint("org.eclipse.ecf.ui.configurationWizards").getExtensions();
                IExtension[] connectWizards = registry.getExtensionPoint("org.eclipse.ecf.ui.connectWizards").getExtensions();
                int i = 0;
                while (i < connectWizards.length) {
                    IConfigurationElement[] ices = connectWizards[i].getConfigurationElements();
                    int j = 0;
                    while (j < ices.length) {
                        if (!ices[j].getName().equals("category")) {
                            final String factoryName = ices[j].getAttribute("containerFactoryName");
                            final IConfigurationWizard wizard = SelectProviderAction.getWizard(this.configurationWizards, factoryName);
                            final IConfigurationElement ice = ices[j];
                            ContainerTypeDescription typeDescription = ContainerFactory.getDefault().getDescriptionByName(factoryName);
                            if (typeDescription != null) {
                                if (!typeDescription.isHidden()) {
                                    this.elements.add(ice);
                                    if (wizard == null) {
                                        this.map.put(ice.getAttribute("name"), new SelectionAdapter(){

                                            public void widgetSelected(SelectionEvent e) {
                                                SelectProviderAction.this.openConnectWizard(ice, factoryName);
                                            }
                                        });
                                    } else {
                                        this.map.put(ice.getAttribute("name"), new SelectionAdapter(){

                                            public void widgetSelected(SelectionEvent e) {
                                                SelectProviderAction.this.openConnectWizard(wizard, ice, factoryName);
                                            }
                                        });
                                    }
                                }
                            } else {
                                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.ui", 2, NLS.bind((String)Messages.SelectProviderAction_WARNING_CONTAINER_TYPE_DESCRIPTION_NOT_FOUND, (Object)factoryName), null));
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void openConnectWizard(IConfigurationElement element, String factoryName) {
        try {
            IContainer container = ContainerFactory.getDefault().createContainer(factoryName);
            IConnectWizard icw = (IConnectWizard)element.createExecutableExtension("class");
            icw.init(this.window.getWorkbench(), container);
            WizardDialog dialog = new WizardDialog(this.window.getShell(), (IWizard)icw);
            dialog.open();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void openConnectWizard(IConfigurationWizard wizard, IConfigurationElement element, String factoryName) {
        try {
            IWorkbench workbench = this.window.getWorkbench();
            wizard.init(workbench, ContainerFactory.getDefault().getDescriptionByName(factoryName));
            WizardDialog dialog = new WizardDialog(this.window.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                IConnectWizard icw = (IConnectWizard)element.createExecutableExtension("class");
                icw.init(workbench, wizard.getConfigurationResult().getContainer());
                dialog = new WizardDialog(this.window.getShell(), (IWizard)icw);
                dialog.open();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void dispose() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
    }

    public void init(IWorkbenchWindow w) {
        this.window = w;
    }

    public void run(IAction action) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.window.getShell(), (ILabelProvider)new ProviderLabelProvider());
        dialog.setElements(this.elements.toArray());
        dialog.setTitle(Messages.SelectProviderAction_selectProviderDialog_title);
        dialog.setMessage(Messages.SelectProviderAction_selectProviderDialog_message);
        dialog.setImage(SharedImages.getImage("IMG_COMMUNICATIONS"));
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            IConfigurationElement element = (IConfigurationElement)result[0];
            String factoryName = element.getAttribute("containerFactoryName");
            IConfigurationWizard wizard = SelectProviderAction.getWizard(this.configurationWizards, factoryName);
            if (wizard == null) {
                this.openConnectWizard(element, factoryName);
            } else {
                this.openConnectWizard(wizard, element, factoryName);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private static IConfigurationWizard getWizard(IExtension[] extensions, String containerFactoryName) {
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (containerFactoryName.equals(elements[j].getAttribute("containerFactoryName"))) {
                    IConfigurationWizard wizard = null;
                    try {
                        wizard = (IConfigurationWizard)elements[j].createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        Activator.log(e.getMessage());
                    }
                    return wizard;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.menu == null) {
            this.menu = new Menu(parent);
            Iterator it = this.map.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                MenuItem item = new MenuItem(this.menu, 8);
                item.setText(name);
                item.addSelectionListener((SelectionListener)this.map.get(name));
            }
        }
        return this.menu;
    }

    public void init(IViewPart view) {
        this.window = view.getSite().getWorkbenchWindow();
    }

    class ProviderLabelProvider
    extends LabelProvider {
        ProviderLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            IConfigurationElement provider = (IConfigurationElement)element;
            return provider.getAttribute("name");
        }
    }
}

