/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

class Socks5Client {
    protected Bytestream.StreamHost streamHost;
    protected String digest;

    public Socks5Client(Bytestream.StreamHost streamHost, String digest) {
        this.streamHost = streamHost;
        this.digest = digest;
    }

    public Socket getSocket(int timeout) throws IOException, XMPPException, InterruptedException, TimeoutException {
        FutureTask<Socket> futureTask = new FutureTask<Socket>(new Callable<Socket>(){

            @Override
            public Socket call() throws Exception {
                Socket socket = new Socket();
                InetSocketAddress socketAddress = new InetSocketAddress(Socks5Client.this.streamHost.getAddress(), Socks5Client.this.streamHost.getPort());
                socket.connect(socketAddress);
                if (!Socks5Client.this.establish(socket)) {
                    socket.close();
                    throw new XMPPException("establishing connection to SOCKS5 proxy failed");
                }
                return socket;
            }
        });
        Thread executor = new Thread(futureTask);
        executor.start();
        try {
            return futureTask.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof XMPPException) {
                    throw (XMPPException)cause;
                }
            }
            throw new IOException("Error while connection to SOCKS5 proxy");
        }
    }

    protected boolean establish(Socket socket) throws IOException {
        byte[] connectionResponse;
        DataInputStream in = new DataInputStream(socket.getInputStream());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        byte[] cmd = new byte[]{5, 1, 0};
        out.write(cmd);
        out.flush();
        byte[] response = new byte[2];
        in.readFully(response);
        if (response[0] != 5 || response[1] != 0) {
            return false;
        }
        byte[] connectionRequest = this.createSocks5ConnectRequest();
        out.write(connectionRequest);
        out.flush();
        try {
            connectionResponse = Socks5Utils.receiveSocks5Message(in);
        }
        catch (XMPPException e) {
            return false;
        }
        connectionRequest[1] = 0;
        return Arrays.equals(connectionRequest, connectionResponse);
    }

    private byte[] createSocks5ConnectRequest() {
        byte[] addr = this.digest.getBytes();
        byte[] data = new byte[7 + addr.length];
        data[0] = 5;
        data[1] = 1;
        data[2] = 0;
        data[3] = 3;
        data[4] = (byte)addr.length;
        System.arraycopy(addr, 0, data, 5, addr.length);
        data[data.length - 2] = 0;
        data[data.length - 1] = 0;
        return data;
    }
}

