/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.util;

import ch.ethz.iks.util.SmartConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class SmartObjectInputStream
extends ObjectInputStream {
    private final ObjectInputStream in;

    public SmartObjectInputStream(InputStream in) throws IOException {
        this.in = new ObjectInputStream(in);
    }

    @Override
    protected final Object readObjectOverride() throws IOException, ClassNotFoundException {
        byte cat = this.in.readByte();
        switch (cat) {
            case 0: {
                return null;
            }
            case 1: {
                try {
                    String type = this.in.readUTF();
                    Class<?> test = (Class<?>)SmartConstants.idToClass.get(type);
                    Class<?> clazz = test != null ? test : Class.forName(type);
                    Constructor<?> constr = clazz.getConstructor(String.class);
                    return constr.newInstance(this.in.readUTF());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
            case 2: {
                return this.in.readObject();
            }
            case 3: {
                return this.readSmartSerializedObject();
            }
            case 4: {
                int length = this.in.readByte();
                String clazzName = this.in.readUTF();
                Class<?> clazz = Class.forName(clazzName);
                Object[] array = (Object[])Array.newInstance(clazz, length);
                int i = 0;
                while (i < length) {
                    byte b = this.in.readByte();
                    array[i] = b == -1 ? null : this.readSmartSerializedObject();
                    ++i;
                }
                return array;
            }
        }
        throw new IllegalStateException("Unhandled case " + cat);
    }

    private Object readSmartSerializedObject() throws IOException, ClassNotFoundException {
        String clazzName = this.in.readUTF();
        Class<?> clazz = Class.forName(clazzName);
        try {
            Constructor<?> constr = clazz.getDeclaredConstructor(null);
            constr.setAccessible(true);
            Object newInstance = constr.newInstance(null);
            int fieldCount = this.in.readInt();
            while (fieldCount > -1) {
                int i = 0;
                while (i < fieldCount) {
                    String fieldName = this.in.readUTF();
                    Object value = this.readObjectOverride();
                    Field field = clazz.getDeclaredField(fieldName);
                    int mod = field.getModifiers();
                    if (!Modifier.isPublic(mod)) {
                        field.setAccessible(true);
                    }
                    field.set(newInstance, value);
                    ++i;
                }
                clazz = clazz.getSuperclass();
                fieldCount = this.in.readInt();
            }
            return newInstance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Error while deserializing " + clazzName + ": " + e.getMessage());
        }
    }

    @Override
    public final int read() throws IOException {
        return this.in.read();
    }

    @Override
    public final int read(byte[] buf, int off, int len) throws IOException {
        return this.in.read(buf, off, len);
    }

    @Override
    public final int available() throws IOException {
        return this.in.available();
    }

    @Override
    public final void close() throws IOException {
        this.in.close();
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public final char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public final short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public final int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public final float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public final double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public final void readFully(byte[] buf) throws IOException {
        this.in.readFully(buf);
    }

    @Override
    public final void readFully(byte[] buf, int off, int len) throws IOException {
        this.in.readFully(buf, off, len);
    }

    @Override
    public final int skipBytes(int len) throws IOException {
        return this.in.skipBytes(len);
    }

    @Override
    public final String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.in.readUTF();
    }
}

