/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.msn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisposeEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.msn.Activator;
import org.eclipse.ecf.internal.provider.msn.MSNID;
import org.eclipse.ecf.internal.provider.msn.MSNRosterEntry;
import org.eclipse.ecf.internal.provider.msn.MSNRosterGroup;
import org.eclipse.ecf.internal.provider.msn.Messages;
import org.eclipse.ecf.presence.IAccountManager;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.IPresenceListener;
import org.eclipse.ecf.presence.IPresenceSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.history.IHistory;
import org.eclipse.ecf.presence.history.IHistoryManager;
import org.eclipse.ecf.presence.im.ChatMessage;
import org.eclipse.ecf.presence.im.ChatMessageEvent;
import org.eclipse.ecf.presence.im.IChat;
import org.eclipse.ecf.presence.im.IChatManager;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.presence.im.ITypingMessage;
import org.eclipse.ecf.presence.im.ITypingMessageSender;
import org.eclipse.ecf.presence.im.TypingMessage;
import org.eclipse.ecf.presence.im.TypingMessageEvent;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterListener;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.presence.roster.IRosterSubscriptionListener;
import org.eclipse.ecf.presence.roster.IRosterSubscriptionSender;
import org.eclipse.ecf.presence.search.ICriteria;
import org.eclipse.ecf.presence.search.IRestriction;
import org.eclipse.ecf.presence.search.ISearch;
import org.eclipse.ecf.presence.search.IUserSearchListener;
import org.eclipse.ecf.presence.search.IUserSearchManager;
import org.eclipse.ecf.presence.search.UserSearchException;
import org.eclipse.ecf.presence.search.message.IMessageSearchManager;
import org.eclipse.ecf.presence.service.IPresenceService;
import org.eclipse.ecf.protocol.msn.ChatSession;
import org.eclipse.ecf.protocol.msn.Contact;
import org.eclipse.ecf.protocol.msn.Group;
import org.eclipse.ecf.protocol.msn.MsnClient;
import org.eclipse.ecf.protocol.msn.Status;
import org.eclipse.ecf.protocol.msn.events.IChatSessionListener;
import org.eclipse.ecf.protocol.msn.events.IContactListListener;
import org.eclipse.ecf.protocol.msn.events.IContactListener;
import org.eclipse.ecf.protocol.msn.events.ISessionListener;

final class MSNContainer
implements IContainer,
IChatManager,
IChatMessageSender,
IPresenceService,
IPresenceSender,
IRoster,
IRosterManager,
IRosterSubscriptionSender,
ITypingMessageSender {
    private final Map chatSessions;
    private final List containerListeners;
    private final List updateListeners;
    private final List messageListeners;
    private final List presenceListeners;
    private final List subscriptionListeners;
    private final List entries;
    private final IUser user;
    private final Namespace namespace;
    private final ID guid;
    private MsnClient client;
    private MSNID connectID;
    protected IHistoryManager historyManager = new IHistoryManager(){

        public IHistory getHistory(ID partnerID, Map options) {
            return null;
        }

        public boolean isActive() {
            return false;
        }

        public void setActive(boolean active) {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    };

    MSNContainer() throws IDCreateException {
        this.guid = IDFactory.getDefault().createGUID();
        this.namespace = IDFactory.getDefault().getNamespaceByName("ecf.msn.msnp");
        this.user = new Account();
        this.chatSessions = new Hashtable();
        this.containerListeners = new ArrayList();
        this.updateListeners = new ArrayList();
        this.messageListeners = new ArrayList();
        this.presenceListeners = new ArrayList();
        this.subscriptionListeners = new ArrayList();
        this.entries = new ArrayList();
    }

    public void connect(ID targetID, IConnectContext connectContext) throws ContainerConnectException {
        if (!(targetID instanceof MSNID)) {
            throw new ContainerConnectException(Messages.MSNContainer_TargetIDNotMSNID);
        }
        this.client = new MsnClient();
        ObjectCallback[] cb = new ObjectCallback[]{new ObjectCallback()};
        try {
            connectContext.getCallbackHandler().handle((Callback[])cb);
            this.client.addSessionListener(new ISessionListener(){

                public void sessionConnected(ChatSession session) {
                    try {
                        Contact contact = session.getParticipants()[0];
                        ID toID = MSNContainer.this.namespace.createInstance(new Object[]{contact.getEmail()});
                        MSNContainer.this.chatSessions.put(toID, session);
                        session.addChatSessionListener((IChatSessionListener)new ChatSessionListener(toID));
                    }
                    catch (IDCreateException iDCreateException) {
                        // empty catch block
                    }
                }
            });
            this.client.getContactList().addContactListListener(new IContactListListener(){

                public void contactAdded(Contact contact) {
                    MSNRosterEntry entry = new MSNRosterEntry(MSNContainer.this, contact, MSNContainer.this.namespace);
                    int i = 0;
                    while (i < MSNContainer.this.entries.size()) {
                        Object e = MSNContainer.this.entries.get(i);
                        if (e instanceof MSNRosterGroup) {
                            MSNRosterGroup group = (MSNRosterGroup)e;
                            if (group.getGroup().contains(contact)) {
                                MSNRosterEntry check = group.getEntryFor(contact);
                                if (check == null) {
                                    check = entry;
                                    contact.addContactListener(new IContactListener(this, entry){
                                        final /* synthetic */ 3 this$1;
                                        private final /* synthetic */ MSNRosterEntry val$entry;
                                        {
                                            this.this$1 = var1_1;
                                            this.val$entry = mSNRosterEntry;
                                        }

                                        public void nameChanged(String name) {
                                            MSNContainer.access$7(3.access$0(this.this$1), this.val$entry.getID(), this.val$entry.getPresence());
                                            MSNContainer.access$8(3.access$0(this.this$1), (IRosterItem)this.val$entry);
                                        }

                                        public void personalMessageChanged(String personalMessage) {
                                            this.val$entry.updatePersonalMessage();
                                            MSNContainer.access$7(3.access$0(this.this$1), this.val$entry.getID(), this.val$entry.getPresence());
                                            MSNContainer.access$8(3.access$0(this.this$1), (IRosterItem)this.val$entry);
                                        }

                                        public void statusChanged(Status status) {
                                            MSNContainer.access$7(3.access$0(this.this$1), this.val$entry.getID(), this.val$entry.getPresence());
                                            MSNContainer.access$8(3.access$0(this.this$1), (IRosterItem)this.val$entry);
                                        }
                                    });
                                    group.add(check);
                                    MSNContainer.this.fireRosterEntryAdded(check);
                                }
                                MSNContainer.this.fireRosterUpdate((IRosterItem)group);
                                return;
                            }
                        } else {
                            MSNRosterEntry check = (MSNRosterEntry)e;
                            if (entry.getContact().equals((Object)check.getContact())) {
                                MSNContainer.this.fireRosterEntryAdded(check);
                                MSNContainer.this.fireRosterUpdate(check.getParent());
                                return;
                            }
                        }
                        ++i;
                    }
                    contact.addContactListener(new IContactListener(this, entry){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ MSNRosterEntry val$entry;
                        {
                            this.this$1 = var1_1;
                            this.val$entry = mSNRosterEntry;
                        }

                        public void nameChanged(String name) {
                            MSNContainer.access$7(3.access$0(this.this$1), this.val$entry.getID(), this.val$entry.getPresence());
                            MSNContainer.access$8(3.access$0(this.this$1), (IRosterItem)this.val$entry);
                        }

                        public void personalMessageChanged(String personalMessage) {
                            this.val$entry.updatePersonalMessage();
                            MSNContainer.access$7(3.access$0(this.this$1), this.val$entry.getID(), this.val$entry.getPresence());
                            MSNContainer.access$8(3.access$0(this.this$1), (IRosterItem)this.val$entry);
                        }

                        public void statusChanged(Status status) {
                            MSNContainer.access$7(3.access$0(this.this$1), this.val$entry.getID(), this.val$entry.getPresence());
                            MSNContainer.access$8(3.access$0(this.this$1), (IRosterItem)this.val$entry);
                        }
                    });
                    MSNContainer.this.entries.add(entry);
                    entry.setParent((IRosterItem)MSNContainer.this);
                    MSNContainer.this.fireRosterEntryAdded(entry);
                    MSNContainer.this.fireRosterUpdate((IRosterItem)MSNContainer.this);
                }

                public void contactRemoved(Contact contact) {
                    MSNRosterEntry entry = MSNContainer.this.findEntry(MSNContainer.this.entries, contact.getEmail());
                    if (entry != null) {
                        MSNContainer.this.fireHandleUnsubscribed(entry.getUser().getID());
                        MSNContainer.this.fireRosterEntryRemoved(entry);
                        MSNContainer.this.fireRosterUpdate(entry.getParent());
                        if (entry.getContact().getGroups().isEmpty()) {
                            entry.setParent((IRosterItem)MSNContainer.this);
                            MSNContainer.this.fireRosterUpdate((IRosterItem)MSNContainer.this);
                        }
                    }
                }

                public void contactAddedUser(String email) {
                    try {
                        MSNContainer.this.fireHandleSubscriptionRequest(MSNContainer.this.namespace.createInstance(new Object[]{email}));
                    }
                    catch (IDCreateException iDCreateException) {
                        // empty catch block
                    }
                }

                public void contactRemovedUser(String email) {
                }

                public void groupAdded(Group group) {
                    MSNContainer.this.entries.add(new MSNRosterGroup(MSNContainer.this, group));
                }

                static /* synthetic */ MSNContainer access$0(3 var0) {
                    return var0.MSNContainer.this;
                }
            });
            this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.guid, targetID));
            this.client.connect(targetID.getName(), (String)cb[0].getObject());
            this.connectID = (MSNID)targetID;
            this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.guid, (ID)this.connectID));
            Activator.getDefault().registerService(this);
        }
        catch (UnsupportedCallbackException e) {
            throw new ContainerConnectException((Throwable)e);
        }
        catch (IOException e) {
            throw new ContainerConnectException((Throwable)e);
        }
    }

    private MSNRosterEntry findEntry(Collection entries, String email) {
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            MSNRosterEntry entry;
            Object o = it.next();
            if (!(o instanceof IRosterGroup ? (entry = this.findEntry(((IRosterGroup)o).getEntries(), email)) != null : (entry = (MSNRosterEntry)o).getUser().getID().getName().equals(email))) continue;
            return entry;
        }
        return null;
    }

    public void disconnect() {
        if (this.client != null) {
            this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.guid, (ID)this.connectID));
            this.client.disconnect();
            this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.guid, (ID)this.connectID));
            Iterator it = this.chatSessions.values().iterator();
            while (it.hasNext()) {
                ((ChatSession)it.next()).close();
            }
            this.chatSessions.clear();
            this.connectID = null;
            this.client = null;
            Activator.getDefault().unregisterService(this);
        }
    }

    public void dispose() {
        this.disconnect();
        this.fireContainerEvent((IContainerEvent)new ContainerDisposeEvent(this.guid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContainerEvent(IContainerEvent event) {
        List list = this.containerListeners;
        synchronized (list) {
            int i = 0;
            while (i < this.containerListeners.size()) {
                ((IContainerListener)this.containerListeners.get(i)).handleEvent(event);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageEvent(ID fromID, String message) {
        List list = this.messageListeners;
        synchronized (list) {
            int i = 0;
            while (i < this.messageListeners.size()) {
                ((IIMMessageListener)this.messageListeners.get(i)).handleMessageEvent((IIMMessageEvent)new ChatMessageEvent(fromID, (IChatMessage)new ChatMessage(fromID, message)));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTypingMessageEvent(ID fromID) {
        List list = this.messageListeners;
        synchronized (list) {
            int i = 0;
            while (i < this.messageListeners.size()) {
                ((IIMMessageListener)this.messageListeners.get(i)).handleMessageEvent((IIMMessageEvent)new TypingMessageEvent(fromID, (ITypingMessage)new TypingMessage(fromID, true, null)));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterUpdate(IRosterItem item) {
        List list = this.updateListeners;
        synchronized (list) {
            int i = 0;
            while (i < this.updateListeners.size()) {
                ((IRosterListener)this.updateListeners.get(i)).handleRosterUpdate((IRoster)this, item);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterEntryAdded(IRosterEntry entry) {
        List list = this.updateListeners;
        synchronized (list) {
            int i = 0;
            while (i < this.updateListeners.size()) {
                ((IRosterListener)this.updateListeners.get(i)).handleRosterEntryAdd(entry);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterEntryRemoved(IRosterEntry entry) {
        List list = this.updateListeners;
        synchronized (list) {
            int i = 0;
            while (i < this.updateListeners.size()) {
                ((IRosterListener)this.updateListeners.get(i)).handleRosterEntryRemove(entry);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePresence(ID id, IPresence presence) {
        List list = this.presenceListeners;
        synchronized (list) {
            int i = 0;
            while (i < this.presenceListeners.size()) {
                ((IPresenceListener)this.presenceListeners.get(i)).handlePresence(id, presence);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHandleSubscriptionRequest(ID fromID) {
        List list = this.subscriptionListeners;
        synchronized (list) {
            int i = 0;
            while (i < this.subscriptionListeners.size()) {
                ((IRosterSubscriptionListener)this.subscriptionListeners.get(i)).handleSubscribeRequest(fromID);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHandleUnsubscribed(ID fromID) {
        List list = this.subscriptionListeners;
        synchronized (list) {
            int i = 0;
            while (i < this.subscriptionListeners.size()) {
                ((IRosterSubscriptionListener)this.subscriptionListeners.get(i)).handleUnsubscribed(fromID);
                ++i;
            }
        }
    }

    public Object getAdapter(Class serviceType) {
        if (serviceType != null && serviceType.isInstance(this)) {
            return this;
        }
        return null;
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.msn.msnp");
    }

    public ID getConnectedID() {
        return this.connectID;
    }

    public ID getID() {
        return this.guid;
    }

    public IAccountManager getAccountManager() {
        return null;
    }

    public IChatRoomManager getChatRoomManager() {
        return null;
    }

    public IPresenceSender getPresenceSender() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IContainerListener listener) {
        if (listener != null) {
            List list = this.containerListeners;
            synchronized (list) {
                if (!this.containerListeners.contains(listener)) {
                    this.containerListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IContainerListener listener) {
        if (listener != null) {
            List list = this.containerListeners;
            synchronized (list) {
                this.containerListeners.remove(listener);
            }
        }
    }

    public void sendPresenceUpdate(ID toID, IPresence presence) throws ECFException {
        if (presence == null || this.client == null) {
            throw new ECFException();
        }
        IPresence.Mode mode = presence.getMode();
        try {
            this.client.setPersonalMessage(presence.getStatus());
            if (presence.getType() == IPresence.Type.UNAVAILABLE) {
                this.disconnect();
            } else if (mode == IPresence.Mode.AVAILABLE || mode == IPresence.Mode.CHAT) {
                this.client.setStatus(Status.ONLINE);
            } else if (mode == IPresence.Mode.AWAY || mode == IPresence.Mode.EXTENDED_AWAY) {
                this.client.setStatus(Status.AWAY);
            } else if (mode == IPresence.Mode.DND) {
                this.client.setStatus(Status.BUSY);
            } else {
                this.client.setStatus(Status.APPEAR_OFFLINE);
            }
        }
        catch (IOException e) {
            throw new ECFException((Throwable)e);
        }
    }

    public IRosterManager getRosterManager() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterListener(IRosterListener listener) {
        List list = this.updateListeners;
        synchronized (list) {
            if (!this.updateListeners.contains(listener)) {
                this.updateListeners.add(listener);
            }
        }
    }

    public IRoster getRoster() {
        return this;
    }

    public IRosterSubscriptionSender getRosterSubscriptionSender() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterSubscriptionListener(IRosterSubscriptionListener listener) {
        if (listener != null) {
            List list = this.subscriptionListeners;
            synchronized (list) {
                if (!this.subscriptionListeners.contains(listener)) {
                    this.subscriptionListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRosterSubscriptionListener(IRosterSubscriptionListener listener) {
        if (listener != null) {
            List list = this.subscriptionListeners;
            synchronized (list) {
                this.subscriptionListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRosterListener(IRosterListener listener) {
        if (listener != null) {
            List list = this.updateListeners;
            synchronized (list) {
                this.updateListeners.remove(listener);
            }
        }
    }

    public Collection getItems() {
        return Collections.unmodifiableCollection(this.entries);
    }

    public IUser getUser() {
        return this.connectID == null ? null : this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPresenceListener(IPresenceListener listener) {
        if (listener != null) {
            List list = this.presenceListeners;
            synchronized (list) {
                if (!this.presenceListeners.contains(listener)) {
                    this.presenceListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePresenceListener(IPresenceListener listener) {
        if (listener != null) {
            List list = this.presenceListeners;
            synchronized (list) {
                this.presenceListeners.remove(listener);
            }
        }
    }

    public IChatManager getChatManager() {
        return this;
    }

    public IChatMessageSender getChatMessageSender() {
        return this;
    }

    public ITypingMessageSender getTypingMessageSender() {
        return this;
    }

    public void sendChatMessage(ID toID, ID threadID, IChatMessage.Type type, String subject, String body, Map properties) throws ECFException {
        this.sendChatMessage(toID, body);
    }

    public void sendChatMessage(ID toID, String body) throws ECFException {
        try {
            ChatSession cs = (ChatSession)this.chatSessions.get(toID);
            if (cs == null) {
                cs = this.client.createChatSession(toID.getName());
                cs.addChatSessionListener((IChatSessionListener)new ChatSessionListener(toID));
                this.chatSessions.put(toID, cs);
            }
            cs.sendMessage(body);
        }
        catch (IOException e) {
            throw new ECFException((Throwable)e);
        }
    }

    public void sendTypingMessage(ID toID, boolean isTyping, String body) throws ECFException {
        try {
            if (isTyping) {
                ChatSession cs = (ChatSession)this.chatSessions.get(toID);
                if (cs == null) {
                    cs = this.client.createChatSession(toID.getName());
                    cs.addChatSessionListener((IChatSessionListener)new ChatSessionListener(toID));
                    this.chatSessions.put(toID, cs);
                }
                cs.sendTypingNotification();
            }
        }
        catch (IOException e) {
            throw new ECFException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(IIMMessageListener listener) {
        if (listener != null) {
            List list = this.messageListeners;
            synchronized (list) {
                if (!this.messageListeners.contains(listener)) {
                    this.messageListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(IIMMessageListener listener) {
        if (listener != null) {
            List list = this.messageListeners;
            synchronized (list) {
                this.messageListeners.remove(listener);
            }
        }
    }

    public void sendRosterAdd(String user, String name, String[] groups) throws ECFException {
        try {
            this.client.getContactList().addContact(user, name);
        }
        catch (IOException e) {
            throw new ECFException((Throwable)e);
        }
    }

    public void sendRosterRemove(ID userID) throws ECFException {
        MSNRosterEntry entry = this.findEntry(this.entries, userID.getName());
        if (entry != null) {
            try {
                this.client.getContactList().removeContact(entry.getContact());
            }
            catch (IOException e) {
                throw new ECFException((Throwable)e);
            }
        }
    }

    public String getName() {
        IUser user = this.getUser();
        return user == null ? null : user.getName();
    }

    public IRosterItem getParent() {
        return null;
    }

    public IHistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public IPresenceContainerAdapter getPresenceContainerAdapter() {
        return this;
    }

    public IChat createChat(ID targetUser, IIMMessageListener messageListener) throws ECFException {
        return null;
    }

    public IUserSearchManager getUserSearchManager() {
        return new IUserSearchManager(){

            public ICriteria createCriteria() {
                return null;
            }

            public IRestriction createRestriction() {
                return null;
            }

            public String[] getUserPropertiesFields() throws ContainerConnectException {
                return null;
            }

            public boolean isEnabled() {
                return false;
            }

            public ISearch search(ICriteria criteria) throws UserSearchException {
                return null;
            }

            public void search(ICriteria criteria, IUserSearchListener listener) {
            }
        };
    }

    public IMessageSearchManager getMessageSearchManager() {
        return null;
    }

    static /* synthetic */ void access$7(MSNContainer mSNContainer, ID iD, IPresence iPresence) {
        mSNContainer.firePresence(iD, iPresence);
    }

    private class Account
    implements IUser {
        private static final long serialVersionUID = 7497082891662391996L;

        private Account() {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public ID getID() {
            return MSNContainer.this.connectID;
        }

        public Map getProperties() {
            return null;
        }

        public String getName() {
            return MSNContainer.this.client.getUserEmail();
        }

        public String getNickname() {
            return MSNContainer.this.client.getDisplayName();
        }
    }

    private class ChatSessionListener
    implements IChatSessionListener {
        private ID toID;

        private ChatSessionListener(ID toID) {
            this.toID = toID;
        }

        public void contactIsTyping(Contact contact) {
            MSNContainer.this.fireTypingMessageEvent(this.toID);
        }

        public void contactJoined(Contact contact) {
        }

        public void contactLeft(Contact contact) {
            MSNContainer.this.chatSessions.remove(this.toID);
        }

        public void messageReceived(Contact contact, String message) {
            MSNContainer.this.fireMessageEvent(this.toID, message);
        }

        public void sessionTimedOut() {
            MSNContainer.this.chatSessions.remove(this.toID);
        }
    }
}

