/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.presence.ui.MessagesView;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

class MessageNotificationPopup
extends PopupDialog {
    private FormToolkit toolkit;
    private Form form;
    private Composite sectionClient;
    private IWorkbenchWindow window;
    private String userName;
    private String message;
    private ID userID;

    MessageNotificationPopup(IWorkbenchWindow window, Shell parent, ID userID) {
        super(parent, 16388, false, false, false, false, false, null, null);
        this.window = window;
        this.userID = userID;
    }

    public boolean close() {
        this.toolkit.dispose();
        return super.close();
    }

    void setContent(String userName, String message) {
        this.userName = userName;
        this.message = message;
    }

    protected Control createContents(Composite parent) {
        this.getShell().setBackground(this.getShell().getDisplay().getSystemColor(15));
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        this.form.getBody().setLayout((Layout)new FillLayout());
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText(this.userName);
        section.setLayout((Layout)new FillLayout());
        this.sectionClient = this.toolkit.createComposite((Composite)section);
        this.sectionClient.setLayout((Layout)new GridLayout());
        Hyperlink link = this.toolkit.createHyperlink(this.sectionClient, this.message, 0);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    MessagesView view = (MessagesView)MessageNotificationPopup.this.window.getActivePage().showView("org.eclipse.ecf.presence.ui.MessagesView");
                    view.selectTab(null, null, null, MessageNotificationPopup.this.userID, MessageNotificationPopup.this.userName);
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                }
            }
        });
        section.setClient((Control)this.sectionClient);
        ImageHyperlink hyperlink = this.toolkit.createImageHyperlink((Composite)section, 0);
        hyperlink.setBackground(null);
        hyperlink.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                MessageNotificationPopup.this.close();
            }
        });
        section.setTextClient((Control)hyperlink);
        this.form.pack();
        return parent;
    }

    public void initializeBounds() {
        this.getShell().setBounds(this.restoreBounds());
    }

    private Rectangle restoreBounds() {
        Rectangle bounds = this.form.getBounds();
        Rectangle maxBounds = this.window.getShell().getMonitor().getClientArea();
        if (bounds.width > -1 && bounds.height > -1) {
            if (maxBounds != null) {
                bounds.width = Math.min(bounds.width, maxBounds.width);
                bounds.height = Math.min(bounds.height, maxBounds.height);
            }
            bounds.width = Math.max(bounds.width, 30);
            bounds.height = Math.max(bounds.height, 30);
        }
        if (bounds.x > -1 && bounds.y > -1 && maxBounds != null && bounds.width > -1 && bounds.height > -1) {
            bounds.x = maxBounds.x + maxBounds.width - bounds.width;
            bounds.y = maxBounds.y + maxBounds.height - bounds.height;
        }
        return bounds;
    }
}

