/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.remoteservices.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.util.BundleStarter;
import org.eclipse.ecf.internal.remoteservices.ui.ServicesViewExtension;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ecf.remoteservice.ui";
    private volatile ServiceTracker containerManagerTracker;
    private static volatile Activator plugin;
    private BundleContext context;
    private IExtensionRegistry extensionRegistry;
    private String servicesViewId;

    public String getLocalServicesViewId() {
        return this.servicesViewId;
    }

    public void setLocalServicesViewId(String viewId) {
        this.servicesViewId = viewId;
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        BundleStarter.startDependents((BundleContext)context, (String[])new String[]{"org.eclipse.ecf.osgi.services.distribution"}, (int)12);
        this.context = context;
        ServiceTracker st = new ServiceTracker(this.context, IExtensionRegistry.class, null);
        st.open();
        this.extensionRegistry = (IExtensionRegistry)st.getService();
        st.close();
    }

    public List<ServicesViewExtension> getLocalServicesViewExtensions() {
        return this.getServicesViewExtensions(Boolean.TRUE);
    }

    public List<ServicesViewExtension> getRemoteServicesViewExtensions() {
        return this.getServicesViewExtensions(Boolean.FALSE);
    }

    public List<ServicesViewExtension> getServicesViewExtensions() {
        return this.getServicesViewExtensions(null);
    }

    public List<ServicesViewExtension> getServicesViewExtensions(Boolean localOnly) {
        IExtensionPoint epoint;
        ArrayList<ServicesViewExtension> results = new ArrayList<ServicesViewExtension>();
        if (this.extensionRegistry != null && (epoint = this.extensionRegistry.getExtensionPoint("org.eclipse.ecf.remoteservice.ui.servicesview")) != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = epoint.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    ServicesViewExtension sve = new ServicesViewExtension(element);
                    if (localOnly != null) {
                        if (localOnly.booleanValue()) {
                            if (!sve.isLocal()) {
                                sve = null;
                            }
                        } else if (sve.isLocal()) {
                            sve = null;
                        }
                    }
                    if (sve != null) {
                        results.add(sve);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                ++n2;
            }
        }
        Collections.sort(results, new Comparator<ServicesViewExtension>(){

            @Override
            public int compare(ServicesViewExtension o1, ServicesViewExtension o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        return results;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        this.extensionRegistry = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public IContainerManager getContainerManager() {
        BundleContext context = this.getBundle().getBundleContext();
        if (this.containerManagerTracker == null) {
            this.containerManagerTracker = new ServiceTracker(context, IContainerManager.class.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }
}

