/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.provider.remoteservice.generic.RegistrySharedObject;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistrationImpl;
import org.eclipse.ecf.remoteservice.AbstractRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;

public class RemoteServiceImpl
extends AbstractRemoteService {
    protected static final long DEFAULT_TIMEOUT = new Long(System.getProperty("ecf.remotecall.timeout", "30000"));
    protected RemoteServiceRegistrationImpl registration = null;
    protected RegistrySharedObject sharedObject = null;

    public RemoteServiceImpl(RegistrySharedObject sharedObject, RemoteServiceRegistrationImpl registration) {
        this.sharedObject = sharedObject;
        this.registration = registration;
    }

    protected IRemoteServiceID getRemoteServiceID() {
        return this.registration.getID();
    }

    protected IRemoteServiceReference getRemoteServiceReference() {
        return this.registration.getReference();
    }

    protected String[] getInterfaceClassNames() {
        return this.registration.getClasses();
    }

    public void callAsync(final IRemoteCall call, IRemoteCallListener listener) {
        this.callAsyncWithTimeout(call, new Callable<IRemoteCallCompleteEvent>(){

            @Override
            public IRemoteCallCompleteEvent call() throws Exception {
                final AtomicReference ar = new AtomicReference();
                RemoteServiceImpl.this.sharedObject.sendCallRequestWithListener(RemoteServiceImpl.this.registration, call, new IRemoteCallListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleEvent(IRemoteCallEvent event) {
                        if (event instanceof IRemoteCallCompleteEvent) {
                            AtomicReference atomicReference = ar;
                            synchronized (atomicReference) {
                                ar.set((IRemoteCallCompleteEvent)event);
                                ar.notify();
                            }
                        }
                    }
                });
                AtomicReference atomicReference = ar;
                synchronized (atomicReference) {
                    while (true) {
                        IRemoteCallCompleteEvent result;
                        if ((result = (IRemoteCallCompleteEvent)ar.get()) != null) {
                            return result;
                        }
                        ar.wait(call.getTimeout());
                    }
                }
            }
        }, listener);
    }

    public Object callSync(IRemoteCall call) throws ECFException {
        return this.sharedObject.callSynch(this.registration, call);
    }

    public void fireAsync(IRemoteCall call) throws ECFException {
        this.sharedObject.sendFireRequest(this.registration, call);
    }
}

