/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.msn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.ecf.internal.provider.msn.MSNRosterEntry;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.protocol.msn.Contact;
import org.eclipse.ecf.protocol.msn.Group;

final class MSNRosterGroup
implements IRosterGroup {
    private final IRoster roster;
    private final List entries;
    private final Group group;

    MSNRosterGroup(IRoster roster, Group group) {
        this.roster = roster;
        this.group = group;
        this.entries = new ArrayList();
    }

    public Collection getEntries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    void add(MSNRosterEntry entry) {
        this.entries.add(entry);
        entry.setParent((IRosterItem)this);
    }

    Group getGroup() {
        return this.group;
    }

    MSNRosterEntry getEntryFor(Contact contact) {
        int i = 0;
        while (i < this.entries.size()) {
            MSNRosterEntry entry = (MSNRosterEntry)this.entries.get(i);
            if (entry.getContact().equals((Object)contact)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        return this.group.getName();
    }

    public IRosterItem getParent() {
        return this.roster;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IRoster getRoster() {
        return this.roster;
    }
}

