/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.internal.core.identity.Activator;
import org.eclipse.osgi.service.debug.DebugOptions;

public class Trace {
    private static final boolean TRACEALL;
    private static final List<String> TRACE_BUNDLES;
    protected static final String PARENTHESIS_OPEN = "(";
    protected static final String PARENTHESIS_CLOSE = ")";
    protected static final String TRACE_STR = "TRACE";
    protected static final String PREFIX_TRACING = "TRACING ";
    protected static final String PREFIX_CHANGING = "CHANGING ";
    protected static final String PREFIX_CATCHING = "CAUGHT ";
    protected static final String PREFIX_THROWING = "THROWN ";
    protected static final String PREFIX_ENTERING = "ENTERING ";
    protected static final String PREFIX_EXITING = "EXITING ";
    protected static final String SEPARATOR_METHOD = "#";
    protected static final String SEPARATOR_PARAMETER = ", ";
    protected static final String SEPARATOR_RETURN = ":";
    protected static final String SEPARATOR_SPACE = " ";
    protected static final String LABEL_OLD_VALUE = "old=";
    protected static final String LABEL_NEW_VALUE = "new=";
    private static final Map<String, Boolean> cachedOptions;

    static {
        String tracePlugins;
        TRACEALL = new Boolean(System.getProperty("org.eclipse.ecf.core.util.traceAll", "false"));
        TRACE_BUNDLES = new ArrayList<String>();
        if (!TRACEALL && (tracePlugins = System.getProperty("org.eclipse.ecf.core.util.traceBundles")) != null) {
            try {
                String[] plugins = tracePlugins.split(",");
                TRACE_BUNDLES.addAll(Arrays.asList(plugins));
            }
            catch (Exception e) {
                System.err.println("Unexpected exception in Trace class static initializer");
                e.printStackTrace(System.err);
            }
        }
        cachedOptions = new HashMap<String, Boolean>();
    }

    private Trace() {
    }

    protected static boolean shouldTrace(String pluginId) {
        return Trace.shouldTrace0(String.valueOf(pluginId) + "/debug");
    }

    protected static boolean shouldTrace0(String option) {
        if (option == null) {
            return false;
        }
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return false;
        }
        DebugOptions debugOptions = activator.getDebugOptions();
        if (debugOptions == null) {
            return false;
        }
        String result = debugOptions.getOption(option);
        return result == null ? false : result.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldTrace(String pluginId, String option) {
        if (pluginId == null) {
            return false;
        }
        if (TRACEALL || TRACE_BUNDLES.contains(pluginId)) {
            return true;
        }
        if (Trace.shouldTrace(pluginId)) {
            Boolean value = null;
            Map<String, Boolean> map = cachedOptions;
            synchronized (map) {
                value = cachedOptions.get(option);
                if (value == null) {
                    value = Trace.shouldTrace0(option);
                    cachedOptions.put(option, value);
                }
            }
            return value;
        }
        return false;
    }

    public static String getArgumentString(Object argument) {
        if (argument == null) {
            return "null";
        }
        if (argument instanceof byte[]) {
            return Trace.getStringFromByteArray((byte[])argument);
        }
        if (argument.getClass().isArray()) {
            return Trace.getArgumentsString((Object[])argument);
        }
        return String.valueOf(argument);
    }

    private static String getStringFromByteArray(byte[] bytes) {
        StringBuilder buf = new StringBuilder("[");
        int i = 0;
        while (i < bytes.length) {
            buf.append(bytes[i]);
            if (i == bytes.length - 1) {
                buf.append("]");
            } else {
                buf.append(",");
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getArgumentsString(Object[] arguments) {
        if (arguments == null) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder("[");
        int i = 0;
        while (i < arguments.length) {
            buffer.append(Trace.getArgumentString(arguments[i]));
            if (i < arguments.length - 1) {
                buffer.append(SEPARATOR_PARAMETER);
            }
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected static void trace(String message) {
        StringBuilder buf = new StringBuilder(PARENTHESIS_OPEN);
        buf.append(TRACE_STR).append(PARENTHESIS_CLOSE).append(Trace.getTimeString()).append(message).append(SEPARATOR_SPACE);
        System.out.println(buf.toString());
    }

    protected static String getTimeString() {
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("[MM/dd/yy;HH:mm:ss:SSS]");
        return df.format(d);
    }

    public static void trace(String pluginId, String message) {
        if (Trace.shouldTrace(pluginId)) {
            Trace.trace(message);
        }
    }

    public static void trace(String pluginId, String option, String message) {
        if (Trace.shouldTrace(pluginId, option)) {
            Trace.trace(message);
        }
    }

    public static void trace(String pluginId, String option, Class clazz, String methodName, String message) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_TRACING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName);
            buf.append(PARENTHESIS_OPEN).append(message).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }

    public static void changing(String pluginId, String option, String valueDescription, Object oldValue, Object newValue) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuilder buf = new StringBuilder(PREFIX_CHANGING);
            buf.append(valueDescription).append(SEPARATOR_SPACE).append(LABEL_OLD_VALUE).append(Trace.getArgumentString(oldValue));
            buf.append(SEPARATOR_PARAMETER).append(LABEL_NEW_VALUE).append(Trace.getArgumentString(newValue));
            Trace.trace(buf.toString());
        }
    }

    public static void changing(String pluginId, String option, Class clazz, String methodName, String valueDescription, Object oldValue, Object newValue) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuilder buf = new StringBuilder(PREFIX_CHANGING);
            buf.append(valueDescription).append(SEPARATOR_SPACE).append(LABEL_OLD_VALUE).append(Trace.getArgumentString(oldValue));
            buf.append(SEPARATOR_PARAMETER).append(LABEL_NEW_VALUE).append(Trace.getArgumentString(newValue));
            buf.append(SEPARATOR_SPACE).append(PARENTHESIS_OPEN).append(clazz.getName()).append(SEPARATOR_METHOD);
            buf.append(methodName).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }

    public static void catching(String pluginId, String option, Class clazz, String methodName, Throwable throwable) {
        if (Trace.shouldTrace(pluginId, option)) {
            String message;
            StringBuilder buf = new StringBuilder(PREFIX_CATCHING);
            if (throwable != null && (message = throwable.getMessage()) != null) {
                buf.append(message).append(SEPARATOR_SPACE);
            }
            buf.append(PARENTHESIS_OPEN).append(clazz.getName()).append(SEPARATOR_METHOD);
            buf.append(methodName).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
            if (throwable != null) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    public static void throwing(String pluginId, String option, Class clazz, String methodName, Throwable throwable) {
        if (Trace.shouldTrace(pluginId, option)) {
            String message;
            StringBuilder buf = new StringBuilder(PREFIX_THROWING);
            if (throwable != null && (message = throwable.getMessage()) != null) {
                buf.append(message).append(SEPARATOR_SPACE);
            }
            buf.append(PARENTHESIS_OPEN).append(clazz.getName()).append(SEPARATOR_METHOD);
            buf.append(methodName).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
            throwable.printStackTrace(System.err);
        }
    }

    public static void entering(String pluginId, String option, Class clazz, String methodName) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_ENTERING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName).append(PARENTHESIS_OPEN).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }

    public static void entering(String pluginId, String option, Class clazz, String methodName, Object parameter) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_ENTERING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName);
            buf.append(PARENTHESIS_OPEN).append(Trace.getArgumentString(parameter)).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }

    public static void entering(String pluginId, String option, Class clazz, String methodName, Object[] parameters) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_ENTERING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName);
            buf.append(PARENTHESIS_OPEN).append(Trace.getArgumentString(parameters)).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }

    public static void exiting(String pluginId, String option, Class clazz, String methodName) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_EXITING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName);
            Trace.trace(buf.toString());
        }
    }

    public static void exiting(String pluginId, String option, Class clazz, String methodName, Object returnValue) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_EXITING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName);
            buf.append(PARENTHESIS_OPEN).append(Trace.getArgumentString(returnValue)).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }
}

