/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient5;

import java.util.Map;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.BrowseFileTransferException;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.INTLMProxyHandler;

public class DefaultNTLMProxyHandler
implements INTLMProxyHandler {
    private static boolean seenNTLM;

    public static boolean seenNTLM() {
        return seenNTLM;
    }

    public static void setSeenNTLM() {
        seenNTLM = true;
    }

    public static void resetSeenNTLM() {
        seenNTLM = false;
    }

    @Override
    public boolean allowNTLMAuthentication(Map<?, ?> connectOptions) {
        seenNTLM = true;
        if (connectOptions != null && connectOptions.get("org.eclipse.ecf.provider.filetransfer.httpclient4.options.ForceNTLMProxy") != null) {
            return true;
        }
        return System.getProperty("org.eclipse.ecf.provider.filetransfer.httpclient4.options.ForceNTLMProxy") != null;
    }

    @Override
    public void handleNTLMProxy(Proxy proxy, int code) throws IncomingFileTransferException {
        seenNTLM = true;
        if (code >= 400) {
            throw new IncomingFileTransferException("HttpClient Provider is not configured to support NTLM proxy authentication.", 477);
        }
    }

    @Override
    public void handleSPNEGOProxy(Proxy proxy, int code) throws BrowseFileTransferException {
        if (code >= 400) {
            throw new BrowseFileTransferException("HttpClient Provider does not support the use of SPNEGO proxy authentication.");
        }
    }
}

