/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share.url;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.example.collab.share.GenericSharedObject;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class ShowURLSharedObject
extends GenericSharedObject {
    private ID receiver;
    private String url;

    public ShowURLSharedObject(ID rcvr, String url) {
        this.receiver = rcvr;
        this.url = url;
    }

    public ShowURLSharedObject() {
    }

    public void init(ISharedObjectConfig config) throws SharedObjectInitException {
        super.init(config);
        Map props = config.getProperties();
        Object[] args = (Object[])props.get("args");
        if (args != null && args.length > 1) {
            this.receiver = (ID)args[0];
            this.url = (String)args[1];
        }
    }

    public ShowURLSharedObject(String url) {
        this.url = url;
    }

    protected String getURL() {
        return this.url;
    }

    protected ReplicaSharedObjectDescription getReplicaDescription(ID remoteMember) {
        Object[] args = new Object[]{this.receiver, this.url};
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put("args", args);
        return new ReplicaSharedObjectDescription(this.getClass(), this.getID(), this.getHomeContainerID(), map, ShowURLSharedObject.getNextReplicateID());
    }

    protected void replicate(ID remoteMember) {
        if (this.receiver == null) {
            super.replicate(remoteMember);
            return;
        }
        if (remoteMember == null) {
            try {
                ReplicaSharedObjectDescription createInfo = this.getReplicaDescription(this.receiver);
                if (createInfo != null) {
                    this.getContext().sendCreate(this.receiver, createInfo);
                }
            }
            catch (IOException e) {
                this.log("Exception in replicateSelf", e);
            }
        }
    }

    public void activated(ID[] others) {
        if (!this.getContext().isGroupManager()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    try {
                        IWebBrowser browser = support.createBrowser(null);
                        browser.openURL(new URL(ShowURLSharedObject.this.url));
                    }
                    catch (Exception e) {
                        MessageDialog.openError(null, (String)Messages.ShowURLSharedObject_MSGBOX_OPENURL_ERROR_TITLE, (String)NLS.bind((String)Messages.ShowURLSharedObject_MSGBOX_OPENURL_ERROR_TEXT, (Object)e.getLocalizedMessage()));
                        ClientPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.example.collab", 4, Messages.ShowURLSharedObject_STATUS_OPENURL_MESSAGE, (Throwable)e));
                    }
                }
            });
        }
        super.activated(others);
        this.destroySelfLocal();
    }
}

