/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

public class EndpointDescriptionWriter {
    protected String indent = "  ";
    protected List<String> xmlNames;

    public EndpointDescriptionWriter() {
        this(null);
    }

    public EndpointDescriptionWriter(List<String> xmlNames) {
        this.xmlNames = xmlNames;
    }

    public Writer writeEndpointDescription(EndpointDescription endpointDescription) throws IOException {
        return this.writeEndpointDescriptions(new EndpointDescription[]{endpointDescription});
    }

    public Writer writeEndpointDescriptions(EndpointDescription[] endpointDescriptions) throws IOException {
        StringWriter writer = new StringWriter().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
        this.writeEndpointDescriptions(writer, endpointDescriptions);
        return writer;
    }

    public void writeEndpointDescription(Writer writer, EndpointDescription endpointDescription) throws IOException {
        if (endpointDescription != null) {
            this.writeEndpointDescriptions(writer, new EndpointDescription[]{endpointDescription});
        }
    }

    public void writeEndpointDescriptions(Writer writer, EndpointDescription[] endpointDescriptions) throws IOException {
        if (endpointDescriptions != null) {
            this.indent(0, writer);
            writer.append("<endpoint-descriptions xmlns=\"http://www.osgi.org/xmlns/rsa/v1.0.0\">");
            this.newLine(writer);
            int i = 0;
            while (i < endpointDescriptions.length) {
                this.writeEndpointDescription(1, writer, endpointDescriptions[i]);
                ++i;
            }
            this.indent(0, writer);
            writer.append("</endpoint-descriptions>");
            this.newLine(writer);
        }
    }

    protected void writeEndpointDescription(int indentLevel, Writer writer, EndpointDescription endpointDescription) throws IOException {
        if (endpointDescription != null) {
            this.indent(indentLevel, writer);
            writer.append("<endpoint-description>");
            this.newLine(writer);
            this.writeProperties(indentLevel, writer, endpointDescription);
            this.indent(indentLevel, writer);
            writer.append("</endpoint-description>");
            this.newLine(writer);
        }
    }

    protected void writeProperties(int indentLevel, Writer writer, EndpointDescription endpointDescription) throws IOException {
        Map properties = endpointDescription.getProperties();
        for (String name : properties.keySet()) {
            this.writeProperty(indentLevel + 1, writer, name, properties.get(name));
        }
    }

    protected void writeProperty(int indentLevel, Writer writer, String name, Object value) throws IOException {
        if (value != null) {
            ComplexProperty complexProperty = this.getComplexProperty(name, value);
            if (complexProperty != null) {
                complexProperty.writeProperty(indentLevel, writer);
                return;
            }
            String valueType = this.getValueType(value);
            if (valueType != null) {
                this.writeValueProperty(indentLevel, name, valueType, value, writer);
                return;
            }
            this.writeUnknownProperty(indentLevel, writer, name, value);
        }
    }

    protected void writeUnknownProperty(int indentLevel, Writer writer, String name, Object value) {
    }

    protected ComplexProperty getComplexProperty(String name, Object value) {
        XmlProperty xmlProperty = this.getXmlProperty(name, value);
        return xmlProperty == null ? this.getMultiValueProperty(name, value) : xmlProperty;
    }

    protected XmlProperty getXmlProperty(String name, Object value) {
        if (this.xmlNames != null && this.xmlNames.contains(name)) {
            return new XmlProperty(name, (String)value);
        }
        return null;
    }

    protected void writeValueProperty(int indentLevel, String name, String valueType, Object value, Writer writer) throws IOException {
        this.indent(indentLevel, writer);
        writer.append("<property name=\"").append(name).append("\" value-type=\"").append(valueType).append("\" value=\"").append(value.toString()).append("\"/>");
        this.newLine(writer);
    }

    protected MultiValueProperty getMultiValueProperty(String key, Object value) {
        if (value instanceof Set) {
            Set s = (Set)value;
            Object first = s.iterator().next();
            if (first == null) {
                return null;
            }
            return new SetProperty(key, s);
        }
        if (value instanceof List) {
            List l = (List)value;
            Object first = l.get(0);
            if (first == null) {
                return null;
            }
            return new ListProperty(key, l);
        }
        if (value.getClass().isArray()) {
            Object[] a = (Object[])value;
            if (a.length == 0 || a[0] == null) {
                return null;
            }
            return new ArrayProperty(key, a);
        }
        return null;
    }

    protected String getValueType(Object value) {
        if (value instanceof String) {
            return "String";
        }
        if (value instanceof Long) {
            return "Long";
        }
        if (value instanceof Double) {
            return "Double";
        }
        if (value instanceof Float) {
            return "Float";
        }
        if (value instanceof Integer) {
            return "Integer";
        }
        if (value instanceof Byte) {
            return "Byte";
        }
        if (value instanceof Character) {
            return "Character";
        }
        if (value instanceof Boolean) {
            return "Boolean";
        }
        if (value instanceof Short) {
            return "Short";
        }
        return null;
    }

    protected Writer newLine(Writer writer) throws IOException {
        return writer.append("\n");
    }

    protected Writer indent(int indentLevel, Writer writer) throws IOException {
        int i = 0;
        while (i < indentLevel) {
            writer.append(this.indent);
            ++i;
        }
        return writer;
    }

    protected class ArrayProperty
    extends MultiValueProperty {
        public ArrayProperty(String key, Object[] value) {
            super(key, value);
        }

        @Override
        public String getValueType() {
            return EndpointDescriptionWriter.this.getValueType(((Object[])this.getValue())[0]);
        }

        @Override
        void writePropertyValues(int indentLevel, Writer writer) throws IOException {
            Object[] a = (Object[])this.getValue();
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("<array>");
            EndpointDescriptionWriter.this.newLine(writer);
            int i = 0;
            while (i < a.length) {
                this.writePropertyValue(indentLevel + 1, a[i], writer);
                ++i;
            }
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("</array>");
            EndpointDescriptionWriter.this.newLine(writer);
        }
    }

    protected abstract class ComplexProperty {
        private String name;
        private Object value;

        public ComplexProperty(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public abstract void writeProperty(int var1, Writer var2) throws IOException;

        protected String getName() {
            return this.name;
        }

        protected Object getValue() {
            return this.value;
        }
    }

    protected class ListProperty
    extends MultiValueProperty {
        public ListProperty(String key, List value) {
            super(key, value);
        }

        @Override
        public String getValueType() {
            return EndpointDescriptionWriter.this.getValueType(((List)this.getValue()).iterator().next());
        }

        @Override
        void writePropertyValues(int indentLevel, Writer writer) throws IOException {
            List l = (List)this.getValue();
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("<list>");
            EndpointDescriptionWriter.this.newLine(writer);
            Iterator i = l.iterator();
            while (i.hasNext()) {
                this.writePropertyValue(indentLevel + 1, i.next(), writer);
            }
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("</list>");
            EndpointDescriptionWriter.this.newLine(writer);
        }
    }

    protected abstract class MultiValueProperty
    extends ComplexProperty {
        public MultiValueProperty(String name, Object value) {
            super(name, value);
        }

        abstract String getValueType();

        abstract void writePropertyValues(int var1, Writer var2) throws IOException;

        @Override
        public void writeProperty(int indentLevel, Writer writer) throws IOException {
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("<property name=\"").append(this.getName()).append("\" value-type=\"").append(this.getValueType()).append("\">");
            EndpointDescriptionWriter.this.newLine(writer);
            this.writePropertyValues(indentLevel + 1, writer);
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("</property>");
            EndpointDescriptionWriter.this.newLine(writer);
        }

        void writePropertyValue(int indentLevel, Object value, Writer writer) throws IOException {
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("<value>").append(value.toString()).append("</value>");
            EndpointDescriptionWriter.this.newLine(writer);
        }
    }

    protected class SetProperty
    extends MultiValueProperty {
        public SetProperty(String key, Set value) {
            super(key, value);
        }

        @Override
        public String getValueType() {
            return EndpointDescriptionWriter.this.getValueType(((Set)this.getValue()).iterator().next());
        }

        @Override
        void writePropertyValues(int indentLevel, Writer writer) throws IOException {
            Set s = (Set)this.getValue();
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("<set>");
            EndpointDescriptionWriter.this.newLine(writer);
            Iterator i = s.iterator();
            while (i.hasNext()) {
                this.writePropertyValue(indentLevel + 1, i.next(), writer);
            }
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("</set>");
        }
    }

    protected class XmlProperty
    extends ComplexProperty {
        public XmlProperty(String name, String xml) {
            super(name, xml);
        }

        void writeXml(int indentLevel, Writer writer) throws IOException {
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("<xml>");
            EndpointDescriptionWriter.this.newLine(writer);
            EndpointDescriptionWriter.this.indent(indentLevel + 1, writer);
            writer.append((String)this.getValue());
            EndpointDescriptionWriter.this.newLine(writer);
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("</xml>");
            EndpointDescriptionWriter.this.newLine(writer);
        }

        @Override
        public void writeProperty(int indentLevel, Writer writer) throws IOException {
            EndpointDescriptionWriter.this.indent(indentLevel, writer);
            writer.append("<property name=\"").append(this.getName()).append("\">");
            EndpointDescriptionWriter.this.newLine(writer);
            this.writeXml(indentLevel + 1, writer);
            writer.append("</property>");
            EndpointDescriptionWriter.this.newLine(writer);
        }
    }
}

