/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.actions.URIClientConnectAction;
import org.eclipse.ecf.internal.example.collab.ui.JoinGroupWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbench;

public class JoinGroupWizard
extends Wizard {
    protected static final String PAGE_TITLE = Messages.JoinGroupWizard_CONNECT;
    private static final String DIALOG_SETTINGS = JoinGroupWizard.class.getName();
    JoinGroupWizardPage mainPage;
    private final IResource resource;
    private String connectID;

    public JoinGroupWizard(IResource resource, IWorkbench workbench) {
        this.resource = resource;
        this.setWindowTitle(PAGE_TITLE);
        IDialogSettings dialogSettings = ClientPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = dialogSettings.getSection(DIALOG_SETTINGS);
        if (wizardSettings == null) {
            wizardSettings = dialogSettings.addNewSection(DIALOG_SETTINGS);
        }
        this.setDialogSettings(wizardSettings);
    }

    public JoinGroupWizard(IResource resource, IWorkbench workbench, String connectID) {
        this(resource, workbench);
        this.connectID = connectID;
    }

    protected ISchedulingRule getSchedulingRule() {
        return this.resource;
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new JoinGroupWizardPage(this.connectID);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        try {
            this.finishPage((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.mainPage.saveDialogSettings();
        URIClientConnectAction client = null;
        String groupName = this.mainPage.getJoinGroupText();
        String nickName = this.mainPage.getNicknameText();
        String containerType = this.mainPage.getContainerType();
        boolean autoLogin = this.mainPage.getAutoLoginFlag();
        try {
            client = new URIClientConnectAction(containerType, groupName, nickName, "", this.resource, autoLogin);
            client.run(null);
        }
        catch (Exception e) {
            String id = ClientPlugin.getDefault().getBundle().getSymbolicName();
            throw new CoreException((IStatus)new Status(4, id, 4, NLS.bind((String)Messages.JoinGroupWizard_COULD_NOT_CONNECT, (Object)groupName), (Throwable)e));
        }
    }
}

