/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.ecf.core.util.OSGIObjectStreamConstants;
import org.eclipse.ecf.core.util.SerDTO;
import org.eclipse.ecf.core.util.SerVersion;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.log.LogService;

public class OSGIObjectInputStream
extends ObjectInputStream
implements OSGIObjectStreamConstants {
    protected ObjectInputStream in;
    protected final Bundle b;
    protected LogService logger;
    ClassLoader classLoader;

    public OSGIObjectInputStream(Bundle b, InputStream in, LogService logger) throws IOException {
        this.b = b;
        this.in = new ReplaceableObjectInputStream(in);
        this.logger = logger;
    }

    public OSGIObjectInputStream(Bundle b, InputStream in) throws IOException {
        this(b, in, null);
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public void setLogService(LogService log) {
        this.logger = log;
    }

    protected void trace(String message) {
        LogService ls = this.logger;
        if (ls != null) {
            ls.log(4, message);
        }
    }

    protected Class loadClass(String classname) throws ClassNotFoundException {
        ClassLoader cl = this.classLoader;
        Bundle bundle = this.b;
        if (cl != null) {
            try {
                return Class.forName(classname, false, cl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bundle == null ? Class.forName(classname) : bundle.loadClass(classname);
    }

    protected Class<?> getClassForType(String type) throws ClassNotFoundException {
        if (type.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (type.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (type.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (type.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        if (type.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (type.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (type.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (type.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        return this.loadClass(type);
    }

    @Override
    protected final Object readObjectOverride() throws IOException, ClassNotFoundException {
        byte type = this.in.readByte();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return this.readSerializedObject();
            }
            case 2: {
                return Version.parseVersion((String)this.in.readUTF());
            }
            case 3: {
                int ol = this.in.readInt();
                Class<?> clazz = this.getClassForType(this.in.readUTF());
                Object oresult = Array.newInstance(clazz, ol);
                int i = 0;
                while (i < ol) {
                    Array.set(oresult, i, this.readObjectOverride());
                    ++i;
                }
                return oresult;
            }
            case 14: {
                Class dictClazz = this.loadClass(this.in.readUTF());
                Dictionary dict = null;
                try {
                    Constructor cons = dictClazz.getDeclaredConstructor(null);
                    cons.setAccessible(true);
                    dict = (Dictionary)cons.newInstance(null);
                }
                catch (Exception e) {
                    throw new IOException("Could not create dictionary instance of clazz=" + dictClazz.getName());
                }
                int dsize = this.in.readInt();
                int i = 0;
                while (i < dsize) {
                    Object key = this.readObjectOverride();
                    Object val = this.readObjectOverride();
                    dict.put(key, val);
                    ++i;
                }
                return dict;
            }
            case 5: {
                int ms = this.in.readInt();
                HashMap<Object, Object> mr = new HashMap<Object, Object>();
                int i = 0;
                while (i < ms) {
                    Object key = this.readObjectOverride();
                    Object val = this.readObjectOverride();
                    mr.put(key, val);
                    ++i;
                }
                return mr;
            }
            case 6: {
                int lsize = this.in.readInt();
                ArrayList<Object> l = new ArrayList<Object>(lsize);
                int i = 0;
                while (i < lsize) {
                    l.add(this.readObjectOverride());
                    ++i;
                }
                return l;
            }
            case 7: {
                int ssize = this.in.readInt();
                HashSet<Object> s = new HashSet<Object>(ssize);
                int i = 0;
                while (i < ssize) {
                    s.add(this.readObjectOverride());
                    ++i;
                }
                return s;
            }
            case 8: {
                int csize = this.in.readInt();
                ArrayList<Object> c = new ArrayList<Object>(csize);
                int i = 0;
                while (i < csize) {
                    c.add(this.readObjectOverride());
                    ++i;
                }
                return c;
            }
            case 9: {
                int isize = this.in.readInt();
                ArrayList<Object> itr = new ArrayList<Object>(isize);
                int i = 0;
                while (i < isize) {
                    itr.add(this.readObjectOverride());
                    ++i;
                }
                return itr;
            }
            case 10: {
                return this.in.readObject();
            }
            case 11: {
                return this.in.readUTF();
            }
            case 20: 
            case 30: {
                return this.in.readLong();
            }
            case 21: 
            case 31: {
                return this.in.readInt();
            }
            case 22: 
            case 32: {
                return this.in.readShort();
            }
            case 23: 
            case 33: {
                return this.in.readBoolean();
            }
            case 24: 
            case 34: {
                return this.in.readByte();
            }
            case 25: 
            case 35: {
                return Character.valueOf(this.in.readChar());
            }
            case 26: 
            case 36: {
                return this.in.readDouble();
            }
            case 27: 
            case 37: {
                return Float.valueOf(this.in.readFloat());
            }
            case 12: {
                return Enum.valueOf(this.loadClass(this.in.readUTF()), this.in.readUTF());
            }
            case 13: {
                return this.readNonSerializedObject();
            }
        }
        throw new IOException("Cannot deserialize object with type=" + type);
    }

    protected Object readExternalizable() throws ClassNotFoundException, IOException {
        return this.in.readObject();
    }

    protected Object readFields(Class<?> clazz, Object inst) throws IOException {
        try {
            int fieldCount = this.in.readInt();
            while (fieldCount > -1) {
                int i = 0;
                while (i < fieldCount) {
                    String fieldName = this.in.readUTF();
                    Field field = clazz.getDeclaredField(fieldName);
                    int mod = field.getModifiers();
                    if (!Modifier.isPublic(mod)) {
                        field.setAccessible(true);
                    }
                    Object value = this.readObjectOverride();
                    field.set(inst, value);
                    ++i;
                }
                clazz = clazz.getSuperclass();
                fieldCount = this.in.readInt();
            }
            return inst;
        }
        catch (Exception e) {
            IOException t = new IOException("Error while deserializing class=" + clazz.getName() + ": " + e.getMessage());
            t.setStackTrace(e.getStackTrace());
            throw t;
        }
    }

    protected Object createInstance(Class<?> clazz) throws IOException {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("Could create new instance of class=" + clazz.getName() + ".  Class must have public no-arg constructor");
        }
    }

    protected Object readNonSerializedObject() throws IOException, ClassNotFoundException {
        String className = this.in.readUTF();
        this.trace("readNonSerializedObject " + className);
        Class clazz = this.loadClass(className);
        Object instance = this.createInstance(clazz);
        return this.readFields(clazz, instance);
    }

    protected Object readSerializedObject() throws IOException, ClassNotFoundException {
        return this.in.readObject();
    }

    @Override
    public final int read() throws IOException {
        return this.in.read();
    }

    @Override
    public final int read(byte[] buf, int off, int len) throws IOException {
        return this.in.read(buf, off, len);
    }

    @Override
    public final int available() throws IOException {
        return this.in.available();
    }

    @Override
    public final void close() throws IOException {
        this.in.close();
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public final char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public final short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public final int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public final float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public final double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public final void readFully(byte[] buf) throws IOException {
        this.in.readFully(buf);
    }

    @Override
    public final void readFully(byte[] buf, int off, int len) throws IOException {
        this.in.readFully(buf, off, len);
    }

    @Override
    public final int skipBytes(int len) throws IOException {
        return this.in.skipBytes(len);
    }

    @Override
    public final String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.in.readUTF();
    }

    class ReplaceableObjectInputStream
    extends ObjectInputStream {
        public ReplaceableObjectInputStream(InputStream ins) throws IOException {
            super(ins);
            this.enableResolveObject(true);
        }

        @Override
        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof SerVersion) {
                return ((SerVersion)obj).toVersion();
            }
            if (obj instanceof SerDTO) {
                SerDTO serDTO = (SerDTO)obj;
                String className = serDTO.getClassname();
                Class clazz = null;
                try {
                    clazz = OSGIObjectInputStream.this.loadClass(className);
                }
                catch (Exception e) {
                    throw new IOException("Could not load class for instance of SerDTO with className=" + className);
                }
                return serDTO.readObject(clazz);
            }
            return super.resolveObject(obj);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return OSGIObjectInputStream.this.loadClass(desc.getName());
            }
            catch (Exception e) {
                return super.resolveClass(desc);
            }
        }
    }
}

