/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerEjectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.presence.ui.Activator;
import org.eclipse.ecf.internal.presence.ui.dialogs.ReceiveAuthorizeRequestDialog;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.Presence;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterListener;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.presence.roster.IRosterSubscriptionListener;
import org.eclipse.ecf.presence.ui.MultiRosterView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MultiRosterAccount {
    protected final MultiRosterView multiRosterView;
    protected IContainer container;
    protected IPresenceContainerAdapter adapter;
    IRosterListener updateListener = new IRosterListener(){

        public void handleRosterUpdate(IRoster roster, final IRosterItem changedValue) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    (this).MultiRosterAccount.this.multiRosterView.refreshTreeViewer(changedValue, true);
                }
            });
        }

        public void handleRosterEntryAdd(final IRosterEntry entry) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    (this).MultiRosterAccount.this.multiRosterView.addEntryToTreeViewer(entry);
                }
            });
        }

        public void handleRosterEntryRemove(final IRosterEntry entry) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    (this).MultiRosterAccount.this.multiRosterView.removeEntryFromTreeViewer(entry);
                }
            });
        }
    };
    IContainerListener containerListener = new IContainerListener(){

        public void handleEvent(IContainerEvent event) {
            if (event instanceof IContainerDisconnectedEvent || event instanceof IContainerEjectedEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        (this).MultiRosterAccount.this.multiRosterView.rosterAccountDisconnected(MultiRosterAccount.this);
                    }
                });
            }
        }
    };
    IRosterSubscriptionListener subscriptionListener = new IRosterSubscriptionListener(){

        public void handleSubscribeRequest(final ID fromID) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        Shell shell = (this).MultiRosterAccount.this.multiRosterView.getViewSite().getShell();
                        ReceiveAuthorizeRequestDialog authRequest = new ReceiveAuthorizeRequestDialog(shell, fromID.getName(), MultiRosterAccount.this.getRoster().getUser().getID().getName());
                        authRequest.setBlockOnOpen(true);
                        authRequest.open();
                        int res = authRequest.getButtonPressed();
                        if (res == 1025) {
                            MultiRosterAccount.this.getRosterManager().getPresenceSender().sendPresenceUpdate(fromID, (IPresence)new Presence(IPresence.Type.SUBSCRIBED));
                        }
                    }
                    catch (ECFException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
            });
        }

        public void handleSubscribed(ID fromID) {
        }

        public void handleUnsubscribed(final ID fromID) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    (this).MultiRosterAccount.this.multiRosterView.removeEntryFromTreeViewer(fromID);
                }
            });
        }
    };

    public MultiRosterAccount(MultiRosterView multiRosterView, IContainer container, IPresenceContainerAdapter adapter) {
        this.multiRosterView = multiRosterView;
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)adapter);
        this.container = container;
        this.adapter = adapter;
        this.container.addListener(this.containerListener);
        this.getRosterManager().addRosterListener(this.updateListener);
        this.getRosterManager().addRosterSubscriptionListener(this.subscriptionListener);
    }

    public IContainer getContainer() {
        return this.container;
    }

    public IPresenceContainerAdapter getPresenceContainerAdapter() {
        return this.adapter;
    }

    public IRosterManager getRosterManager() {
        return this.getPresenceContainerAdapter().getRosterManager();
    }

    public IRoster getRoster() {
        return this.getRosterManager().getRoster();
    }

    public void dispose() {
        this.getRosterManager().removeRosterSubscriptionListener(this.subscriptionListener);
        this.getRosterManager().removeRosterListener(this.updateListener);
        this.container.removeListener(this.containerListener);
    }
}

