/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import org.eclipse.ecf.core.util.OSGIObjectInputStream;
import org.eclipse.ecf.provider.util.IClassLoaderMapper;
import org.osgi.framework.Bundle;

public class IdentifiableObjectInputStream
extends OSGIObjectInputStream {
    IClassLoaderMapper mapper;

    public IdentifiableObjectInputStream(IClassLoaderMapper map, InputStream ins) throws IOException {
        super(null, ins);
        this.mapper = map;
    }

    public IdentifiableObjectInputStream(Bundle b, InputStream ins) throws IOException {
        super(b, ins);
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = this.readUTF();
        if (name == null || this.mapper == null) {
            return super.resolveClass(desc);
        }
        ClassLoader cl = this.mapper.mapNameToClassLoader(name);
        if (cl == null) {
            return super.resolveClass(desc);
        }
        return Class.forName(desc.getName(), true, cl);
    }
}

