/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ecf.internal.ui.Activator;
import org.eclipse.ecf.ui.ContainerConfigurationResult;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class ContainerConnectWizardDialog
extends WizardDialog {
    public ContainerConnectWizardDialog(Shell parentShell, IWorkbench workbench, ContainerConfigurationResult containerHolder) throws CoreException {
        super(parentShell, (IWizard)ContainerConnectWizardDialog.getWizard(workbench, containerHolder));
    }

    protected static IConnectWizard getWizard(IWorkbench workbench, ContainerConfigurationResult containerHolder) throws CoreException {
        IConnectWizard connectWizard = null;
        IConfigurationElement ce = ContainerConnectWizardDialog.findConnectWizardConfigurationElements(containerHolder)[0];
        connectWizard = (IConnectWizard)ce.createExecutableExtension("class");
        connectWizard.init(workbench, containerHolder.getContainer());
        return connectWizard;
    }

    protected static IConfigurationElement[] findConnectWizardConfigurationElements(ContainerConfigurationResult containerHolder) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtensionRegistry reg = Activator.getDefault().getExtensionRegistry();
        if (reg != null) {
            IExtensionPoint extensionPoint = reg.getExtensionPoint("org.eclipse.ecf.ui.connectWizards");
            if (extensionPoint == null) {
                return null;
            }
            IConfigurationElement[] ce = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < ce.length) {
                String value = ce[i].getAttribute("containerFactoryName");
                if (value != null && value.equals(containerHolder.getContainerTypeDescription().getName())) {
                    result.add(ce[i]);
                }
                ++i;
            }
            return result.toArray(new IConfigurationElement[0]);
        }
        return new IConfigurationElement[0];
    }

    public boolean hasConnectWizard(ContainerConfigurationResult containerHolder) {
        return ContainerConnectWizardDialog.findConnectWizardConfigurationElements(containerHolder).length > 0;
    }
}

