/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.protocol.bittorrent.internal.net;

import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import org.eclipse.ecf.protocol.bittorrent.internal.net.ConnectionInfo;
import org.eclipse.ecf.protocol.bittorrent.internal.net.PeerConnection;
import org.eclipse.ecf.protocol.bittorrent.internal.net.TorrentManager;

class ConnectionPool {
    static final Random RANDOM = new SecureRandom();
    private static final int OPTIMISTIC_UNCHOKE_ROTATION_TIME = 30;
    private static final int MAX_UNCHOKED_PEERS = 4;
    private final Vector connections;
    private final LinkedList targets;
    private final TorrentManager manager;
    private Thread unchokingThread;
    private int maxConnections = 50;
    private int size = 0;
    private int unchokedPeers = 0;
    private boolean connected = false;

    ConnectionPool(TorrentManager manager) {
        this.manager = manager;
        this.connections = new Vector(this.maxConnections);
        this.targets = new LinkedList();
    }

    private synchronized void unchoke() {
        if (this.size <= 4 || this.unchokedPeers < 4) {
            return;
        }
        int unchoke = RANDOM.nextInt(this.size);
        PeerConnection connection = (PeerConnection)this.connections.get(unchoke);
        while (connection.isChoking()) {
            unchoke = RANDOM.nextInt(this.size);
            connection = (PeerConnection)this.connections.get(unchoke);
        }
        connection.queueUnchokeMessage();
        int choke = RANDOM.nextInt(this.size);
        connection = (PeerConnection)this.connections.get(choke);
        while (choke != unchoke && !connection.isChoking()) {
            choke = RANDOM.nextInt(this.size);
            connection = (PeerConnection)this.connections.get(choke);
        }
        connection.queueChokeMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectTo(String ip, int port) throws UnsupportedEncodingException {
        if (this.unchokingThread == null) {
            this.unchokingThread = new OptimisticUnchokingThread();
            this.unchokingThread.start();
        } else if (this.size == this.maxConnections) {
            return;
        }
        this.connected = true;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            int i = 0;
            while (i < this.connections.size()) {
                PeerConnection connection = (PeerConnection)this.connections.get(i);
                if (connection.isInitialized() && connection.isConnectedTo(ip, port)) {
                    return;
                }
                ++i;
            }
            this.targets.add(new ConnectionInfo(ip, port));
            i = 0;
            while (i < this.connections.size()) {
                if (!((PeerConnection)this.connections.get(i)).isInitialized()) {
                    this.notify();
                    return;
                }
                ++i;
            }
            PeerConnection connection = new PeerConnection(this, this.manager);
            this.connections.add(connection);
            connection.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectTo(SocketChannel channel) throws UnsupportedEncodingException {
        if (this.unchokingThread == null) {
            this.unchokingThread = new OptimisticUnchokingThread();
            this.unchokingThread.start();
        } else if (this.size == this.maxConnections) {
            return;
        }
        this.connected = true;
        Socket socket = channel.socket();
        String ip = socket.getLocalAddress().getHostAddress();
        int port = socket.getLocalPort();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            int i = 0;
            while (i < this.connections.size()) {
                PeerConnection connection = (PeerConnection)this.connections.get(i);
                if (connection.isConnectedTo(ip, port)) {
                    return;
                }
                ++i;
            }
            this.targets.add(new ConnectionInfo(channel));
            i = 0;
            while (i < this.connections.size()) {
                if (!((PeerConnection)this.connections.get(i)).isInitialized()) {
                    this.notify();
                    return;
                }
                ++i;
            }
            PeerConnection connection = new PeerConnection(this, this.manager);
            this.connections.add(connection);
            connection.start();
        }
    }

    synchronized void close() {
        this.connected = false;
        int i = 0;
        while (i < this.connections.size()) {
            ((PeerConnection)this.connections.get(i)).close();
            ++i;
        }
        this.targets.clear();
        this.notifyAll();
    }

    synchronized boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionInfo dequeue() {
        LinkedList linkedList = this.targets;
        synchronized (linkedList) {
            return this.targets.isEmpty() ? null : (ConnectionInfo)this.targets.removeFirst();
        }
    }

    void disconnectSeeds() {
        int i = 0;
        while (i < this.connections.size()) {
            PeerConnection connection = (PeerConnection)this.connections.get(i);
            if (connection.isInitialized() && connection.isSeed()) {
                connection.close();
            }
            ++i;
        }
    }

    void unchokedPeerCleared() {
        --this.unchokedPeers;
    }

    synchronized void setMaxConnections(int maxConnections) {
        if (this.maxConnections < maxConnections) {
            this.connections.ensureCapacity(maxConnections);
        } else if (this.maxConnections > maxConnections) {
            int i = 0;
            while (i < maxConnections) {
                if (!((PeerConnection)this.connections.get(i)).isInitialized()) {
                    int j = this.connections.size();
                    while (j > i) {
                        PeerConnection conn = (PeerConnection)this.connections.get(j);
                        if (conn.isInitialized()) {
                            this.connections.remove(i);
                            this.connections.add(i, this.connections.remove(j - 1));
                        }
                        --j;
                    }
                }
                ++i;
            }
            i = maxConnections;
            while (i < this.maxConnections) {
                ((PeerConnection)this.connections.get(i)).close();
                ++i;
            }
        }
        this.maxConnections = maxConnections;
    }

    synchronized boolean checkUnchoke() {
        if (this.unchokedPeers == 4) {
            return false;
        }
        ++this.unchokedPeers;
        return true;
    }

    void connectionCreated() {
        ++this.size;
    }

    void connectionClosed() {
        --this.size;
        if (this.size == 0 && this.unchokingThread != null) {
            this.unchokingThread.interrupt();
            this.unchokingThread = null;
        }
    }

    void connectionDestroyed(PeerConnection connection) {
        this.connections.remove(connection);
    }

    int getConnected() {
        return this.size;
    }

    void queueHaveMessage(int piece) {
        int i = 0;
        while (i < this.connections.size()) {
            PeerConnection connection = (PeerConnection)this.connections.get(i);
            if (connection.isInitialized()) {
                connection.queueHaveMessage(piece);
            }
            ++i;
        }
    }

    boolean isEmpty() {
        return this.connections.isEmpty();
    }

    private class OptimisticUnchokingThread
    extends Thread {
        public OptimisticUnchokingThread() {
            super("Optimistic Unchoking Thread " + ConnectionPool.this.manager.getTorrentFile().getName());
        }

        public void run() {
            while (true) {
                int i = 0;
                while (i < 30) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    int j = 0;
                    while (j < ConnectionPool.this.connections.size()) {
                        PeerConnection conn = (PeerConnection)ConnectionPool.this.connections.get(j);
                        if (conn.isInitialized()) {
                            conn.queueSpeeds();
                        }
                        ++j;
                    }
                    ++i;
                }
                ConnectionPool.this.unchoke();
            }
        }
    }
}

