/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ui.wizards;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.internal.ui.wizards.WorkbenchWizardElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class WizardCollectionElement
extends AdaptableList
implements IPluginContribution,
IWizardCategory {
    private String id;
    private String pluginId;
    private String name;
    private WizardCollectionElement parent;
    private AdaptableList wizards = new AdaptableList();
    private IConfigurationElement configElement;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public WizardCollectionElement(String id, String pluginId, String name, WizardCollectionElement parent) {
        this.name = name;
        this.id = id;
        this.pluginId = pluginId;
        this.parent = parent;
    }

    public WizardCollectionElement(IConfigurationElement element, WizardCollectionElement parent) {
        this.configElement = element;
        this.id = this.configElement.getAttribute("id");
        this.parent = parent;
    }

    public AdaptableList add(IAdaptable a) {
        if (a instanceof WorkbenchWizardElement) {
            this.wizards.add(a);
        } else {
            super.add(a);
        }
        return this;
    }

    public void remove(IAdaptable a) {
        if (a instanceof WorkbenchWizardElement) {
            this.wizards.remove(a);
        } else {
            super.remove(a);
        }
    }

    public WizardCollectionElement findChildCollection(IPath searchPath) {
        Object[] c = this.getChildren(null);
        String searchString = searchPath.segment(0);
        int i = 0;
        while (i < c.length) {
            WizardCollectionElement currentCategory = (WizardCollectionElement)((Object)c[i]);
            if (currentCategory.getId().equals(searchString)) {
                if (searchPath.segmentCount() == 1) {
                    return currentCategory;
                }
                return currentCategory.findChildCollection(searchPath.removeFirstSegments(1));
            }
            ++i;
        }
        return null;
    }

    public WizardCollectionElement findCategory(String lid) {
        Object[] c = this.getChildren(null);
        int i = 0;
        while (i < c.length) {
            WizardCollectionElement currentCategory = (WizardCollectionElement)((Object)c[i]);
            if (lid.equals(currentCategory.getId())) {
                return currentCategory;
            }
            WizardCollectionElement childCategory = currentCategory.findCategory(lid);
            if (childCategory != null) {
                return childCategory;
            }
            ++i;
        }
        return null;
    }

    public WorkbenchWizardElement findWizard(String searchId, boolean recursive) {
        IWizardDescriptor[] w = this.getWizards();
        int i = 0;
        while (i < w.length) {
            WorkbenchWizardElement currentWizard = (WorkbenchWizardElement)w[i];
            if (currentWizard.getId().equals(searchId)) {
                return currentWizard;
            }
            ++i;
        }
        if (!recursive) {
            return null;
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            WizardCollectionElement child = (WizardCollectionElement)((Object)iterator.next());
            WorkbenchWizardElement result = child.findWizard(searchId, true);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel(Object o) {
        return this.configElement != null ? this.configElement.getAttribute("name") : this.name;
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public IPath getPath() {
        if (this.parent == null) {
            return new Path("");
        }
        return this.parent.getPath().append(this.getId());
    }

    public IWizardDescriptor[] getWizards() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.wizards.IWizardDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IWizardDescriptor[])this.wizards.getTypedChildren((Class)clazz);
    }

    public WorkbenchWizardElement[] getWorkbenchWizardElements() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ecf.internal.ui.wizards.WorkbenchWizardElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (WorkbenchWizardElement[])this.wizards.getTypedChildren((Class)clazz);
    }

    public boolean isEmpty() {
        return this.size() == 0 && this.wizards.size() == 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("WizardCollection, ");
        buf.append(this.children.size());
        buf.append(" children, ");
        buf.append(this.wizards.size());
        buf.append(" wizards");
        return buf.toString();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.configElement != null ? this.configElement.getContributor().getName() : this.pluginId;
    }

    public IWizardCategory getParent() {
        return this.parent;
    }

    public IWizardCategory[] getCategories() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ui.wizards.IWizardCategory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IWizardCategory[])this.getTypedChildren(clazz);
    }

    public WizardCollectionElement[] getCollectionElements() {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ecf.internal.ui.wizards.WizardCollectionElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (WizardCollectionElement[])this.getTypedChildren(clazz);
    }

    public AdaptableList getWizardAdaptableList() {
        return this.wizards;
    }

    public String getLabel() {
        return this.getLabel((Object)this);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public WizardCollectionElement getParentCollection() {
        return this.parent;
    }

    public IWizardDescriptor findWizard(String i) {
        return this.findWizard(i, true);
    }

    public IWizardCategory findCategory(IPath path) {
        return this.findChildCollection(path);
    }
}

