/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.SelectContainerException;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;

public class AbstractConsumerContainerSelector
extends AbstractContainerSelector {
    protected IRemoteServiceContainer selectExistingConsumerContainer(ID endpointID, String[] remoteSupportedConfigs, ID connectTargetID) {
        IContainer[] containers = this.getContainers();
        if (containers == null) {
            return null;
        }
        int i = 0;
        while (i < containers.length) {
            if (!this.matchContainerID(containers[i], endpointID)) {
                IRemoteServiceContainerAdapter adapter = this.hasRemoteServiceContainerAdapter(containers[i]);
                if (adapter != null && this.matchConnectNamespace(containers[i], endpointID, connectTargetID) && this.matchSupportedConfigs(containers[i], remoteSupportedConfigs) && this.matchNotConnected(containers[i], endpointID, connectTargetID)) {
                    this.trace("selectExistingConsumerContainer", "MATCH of existing remote service container id=" + containers[i].getID() + " endpointID=" + endpointID + " remoteSupportedConfigs=" + (remoteSupportedConfigs == null ? "[]" : Arrays.asList(remoteSupportedConfigs).toString()));
                    return new RemoteServiceContainer(containers[i], adapter);
                }
                this.trace("selectExistingConsumerContainer", "No match of existing remote service container id=" + containers[i].getID() + " endpointID=" + endpointID + " remoteSupportedConfigs=" + (remoteSupportedConfigs == null ? "[]" : Arrays.asList(remoteSupportedConfigs).toString()));
            }
            ++i;
        }
        return null;
    }

    protected boolean matchNotConnected(IContainer container, ID endpointID, ID connectTargetID) {
        ID connectedID = container.getConnectedID();
        return connectedID == null || connectedID.equals((Object)endpointID) || connectedID.equals((Object)connectTargetID);
    }

    protected boolean matchSupportedConfigs(IContainer container, String[] remoteSupportedConfigs) {
        if (remoteSupportedConfigs == null) {
            return false;
        }
        ContainerTypeDescription description = this.getContainerTypeDescription(container);
        if (description == null) {
            return false;
        }
        String[] importedConfigs = description.getImportedConfigs(remoteSupportedConfigs);
        return importedConfigs != null && importedConfigs.length != 0;
    }

    protected void connectContainerToTarget(IRemoteServiceContainer rsContainer, ID connectTargetID) {
        if (connectTargetID == null) {
            return;
        }
        IContainer container = rsContainer.getContainer();
        ID connectedID = container.getConnectedID();
        if (connectedID == null) {
            try {
                this.connectContainer(container, connectTargetID, this.getConnectContext(container, connectTargetID));
            }
            catch (ContainerConnectException e) {
                this.logException("Exception connecting container id=" + container.getID() + " to connectTargetID=" + connectTargetID, (Exception)((Object)e));
            }
        }
    }

    protected IConnectContext getConnectContext(IContainer container, ID connectTargetID) {
        return null;
    }

    protected IRemoteServiceContainer createAndConfigureConsumerContainer(String[] remoteSupportedConfigs, Map remoteExportedProperties) throws SelectContainerException {
        if (remoteSupportedConfigs == null || remoteSupportedConfigs.length == 0) {
            return null;
        }
        IContainerFactory containerFactory = this.getContainerFactory();
        if (containerFactory == null) {
            return null;
        }
        List containerTypeDescriptions = containerFactory.getDescriptions();
        if (containerTypeDescriptions == null) {
            return null;
        }
        for (ContainerTypeDescription desc : containerTypeDescriptions) {
            IRemoteServiceContainer rsContainer;
            Dictionary importedConfigProperties;
            String selectedConfig;
            String[] localImportedConfigs = desc.getImportedConfigs(remoteSupportedConfigs);
            if (localImportedConfigs == null || (selectedConfig = this.selectLocalImportedConfig(localImportedConfigs, importedConfigProperties = desc.getPropertiesForImportedConfigs(localImportedConfigs, PropertiesUtil.createDictionaryFromMap(remoteExportedProperties)))) == null || (rsContainer = this.createContainer(desc, selectedConfig, PropertiesUtil.createMapFromDictionary(importedConfigProperties))) == null) continue;
            return rsContainer;
        }
        return null;
    }

    protected IRemoteServiceContainer createContainer(ContainerTypeDescription containerTypeDescription, String containerTypeDescriptionName, Map properties) throws SelectContainerException {
        try {
            IContainer container = properties == null ? this.getContainerFactory().createContainer(containerTypeDescriptionName) : this.getContainerFactory().createContainer(containerTypeDescriptionName, properties);
            IRemoteServiceContainerAdapter adapter = (IRemoteServiceContainerAdapter)container.getAdapter(IRemoteServiceContainerAdapter.class);
            if (adapter == null) {
                throw new SelectContainerException("Container config id=" + containerTypeDescriptionName + " does not implement IRemoteServiceContainerAdapter", null, containerTypeDescription);
            }
            return new RemoteServiceContainer(container);
        }
        catch (ContainerCreateException e) {
            String message = "Cannot create container config id=" + containerTypeDescriptionName;
            this.logException(message, (Exception)((Object)e));
            throw new SelectContainerException(message, e, containerTypeDescription);
        }
    }

    protected String selectLocalImportedConfig(String[] localConfigTypes, Dictionary importedConfigProperties) {
        if (localConfigTypes == null || localConfigTypes.length == 0) {
            return null;
        }
        return localConfigTypes[0];
    }
}

