/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.provider.zookeeper.core.IDiscoveryConfig;
import org.eclipse.ecf.provider.zookeeper.util.Geo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDiscoveryConfig
implements IDiscoveryConfig {
    protected static Map<String, Object> defaultConfigProperties = new HashMap<String, Object>();
    public static final String DEFAULT_FLAVOR = "zoodiscovery.flavor.standalone=" + Geo.getLocation();
    public static final String TEMPDIR_DEFAULT = System.getProperties().getProperty("java.io.tmpdir");
    public static final String DATADIR_DEFAULT = "zookeeperData";
    public static final String DATALOGDIR_DEFAULT = "zookeeperData";
    public static final String SERVER_PORT_DEFAULT = "2888";
    public static final String ELECTION_PORT_DEFAULT = "3888";
    public static final String CLIENT_PORT_DEFAULT = "2181";
    public static final String TICKTIME_DEFAULT = "2000";
    public static final String INITLIMIT_DEFAULT = "50";
    public static final String SYNCLIMIT_DEFAULT = "2";
    public static final String ZOODISCOVERY_PREFIX = "zoodiscovery.";

    static {
        defaultConfigProperties.put("tempDir", System.getProperty("zoodiscovery.tempDir", TEMPDIR_DEFAULT));
        defaultConfigProperties.put("dataDir", System.getProperty("zoodiscovery.dataDir", "zookeeperData"));
        defaultConfigProperties.put("dataLogDir", System.getProperty("zoodiscovery.dataLogDir", "dataDir"));
        defaultConfigProperties.put("clientPort", System.getProperty("zoodiscovery.clientPort", CLIENT_PORT_DEFAULT));
        defaultConfigProperties.put("tickTime", System.getProperty("zoodiscovery.tickTime", TICKTIME_DEFAULT));
        defaultConfigProperties.put("initLimit", System.getProperty("zoodiscovery.initLimit", INITLIMIT_DEFAULT));
        defaultConfigProperties.put("syncLimit", System.getProperty("zoodiscovery.syncLimit", SYNCLIMIT_DEFAULT));
        defaultConfigProperties.put("serverPort", System.getProperty("zoodiscovery.serverPort", SERVER_PORT_DEFAULT));
        defaultConfigProperties.put("electionPort", System.getProperty("zoodiscovery.electionPort", ELECTION_PORT_DEFAULT));
        defaultConfigProperties.put("preAllocSize", 1);
        defaultConfigProperties.put("consoleLog", System.getProperty("zoodiscovery.consoleLog", null));
    }

    @Override
    public Map<String, Object> getConfigProperties() {
        return Collections.unmodifiableMap(defaultConfigProperties);
    }

    public static String getDefaultTarget() {
        String f = System.getProperty("zoodiscovery.flavor");
        if (f == null) {
            f = DEFAULT_FLAVOR;
        }
        return f;
    }

    public static boolean getConsoleLog() {
        Map<String, Object> props = new DefaultDiscoveryConfig().getConfigProperties();
        Object f = props.get("consoleLog");
        return f != null;
    }
}

