/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.ecf.internal.ssl.SSLContextHelper;

public class ECFSSLSocketFactory
extends SSLSocketFactory {
    public static final String DEFAULT_SSL_PROTOCOL = "https.protocols";
    private SSLContext sslContext = null;
    private String defaultProtocolNames = System.getProperty("https.protocols");

    private SSLSocketFactory getSSLSocketFactory() throws IOException {
        if (this.sslContext == null) {
            try {
                this.sslContext = this.getSSLContext(this.defaultProtocolNames);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.sslContext == null ? (SSLSocketFactory)SSLSocketFactory.getDefault() : this.sslContext.getSocketFactory();
    }

    public SSLContext getSSLContext(String protocols) {
        return SSLContextHelper.getSSLContext(protocols);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.getSSLSocketFactory().createSocket();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.getSSLSocketFactory().createSocket(socket, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        try {
            return this.getSSLSocketFactory().getDefaultCipherSuites();
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        try {
            return this.getSSLSocketFactory().getSupportedCipherSuites();
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSSLSocketFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.getSSLSocketFactory().createSocket(address, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress arg2, int arg3) throws IOException {
        return this.getSSLSocketFactory().createSocket(address, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress address, int localPort) throws IOException, UnknownHostException {
        return this.getSSLSocketFactory().createSocket(host, port, address, localPort);
    }
}

