/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.filetransfer.ui;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.filetransfer.IFileTransfer;
import org.eclipse.ecf.filetransfer.IFileTransferPausable;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IOutgoingFileTransfer;
import org.eclipse.ecf.internal.filetransfer.ui.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class FileTransfersView
extends ViewPart {
    public static final Map transfers = new HashMap();
    public static final String ID = "org.eclipse.ecf.filetransfer.ui.FileTransfersView";
    private static final String[] COLUMNS = new String[]{Messages.getString("FileTransfersView_COLUMN_NAME"), Messages.getString("FileTransfersView_COLUMN_DOWNLOAD"), Messages.getString("FileTransfersView_COLUMN_UPLOAD"), Messages.getString("FileTransfersView_COLUMN_LOCAL_FILE"), Messages.getString("FileTransfersView_COLUMN_DONE"), Messages.getString("FileTransfersView_COLUMN_START_TIME"), Messages.getString("FileTransfersView_COLUMN_END_TIME"), Messages.getString("FileTransfersView_COLUMN_RATE")};
    private static final int[] WIDTHS = new int[]{225, 70, 70, 325, 50, 90, 90, 75};
    private static final String DATEFORMAT = "HH:mm:ss";
    static final SimpleDateFormat SDF = new SimpleDateFormat("HH:mm:ss");
    static final Object[] EMPTY_ARRAY = new Object[0];
    private static final double GIGABYTE = Math.pow(2.0, 30.0);
    private static final double MEGABYTE = Math.pow(2.0, 20.0);
    private static final double KILOBYTE = Math.pow(2.0, 10.0);
    private static final int NAME = 0;
    private static final int DOWNLOADED = 1;
    private static final int UPLOADED = 2;
    private static final int FILENAME = 3;
    private static final int DONE = 4;
    private static final int STARTTIME = 5;
    private static final int ENDTIME = 6;
    private static final int RATE = 7;
    TableViewer viewer;
    private Table table;
    private Action resumeAction;
    private Action pauseAction;
    private Action removeAction;
    private Action launchAction;
    private static FileTransfersView instance;

    public static FileTransfersView addTransfer(IFileTransfer transfer) {
        FileTransferEntry entry = new FileTransferEntry(transfer, null);
        transfers.put(transfer, entry);
        if (instance != null) {
            instance.add(entry);
        }
        return instance;
    }

    public static FileTransfersView addTransfer(IFileTransfer transfer, String localFileName) {
        FileTransferEntry entry = new FileTransferEntry(transfer, localFileName);
        transfers.put(transfer, entry);
        if (instance != null) {
            instance.add(entry);
        }
        return instance;
    }

    static String getTwoDigitNumber(long value) {
        if ((double)value > GIGABYTE) {
            double num = (double)value / GIGABYTE;
            return String.valueOf(Double.toString(Math.floor(num * 100.0) / 100.0)) + " " + Messages.getString("FileTransfersView_GB");
        }
        if ((double)value > MEGABYTE) {
            double num = (double)value / MEGABYTE;
            return String.valueOf(Double.toString(Math.floor(num * 100.0) / 100.0)) + " " + Messages.getString("FileTransfersView_MB");
        }
        if ((double)value > KILOBYTE) {
            double num = (double)value / KILOBYTE;
            return String.valueOf(Double.toString(Math.floor(num * 100.0) / 100.0)) + " " + Messages.getString("FileTransfersView_KB");
        }
        return String.valueOf(value) + " " + Messages.getString("FileTransfersView_BYTES");
    }

    public FileTransfersView() {
        instance = this;
    }

    public void dispose() {
        instance = null;
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 268501762);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.table = this.viewer.getTable();
        int i = 0;
        while (i < WIDTHS.length) {
            TableColumn col = new TableColumn(this.table, 16384);
            col.setText(COLUMNS[i]);
            col.setAlignment(0x1000000);
            col.setWidth(WIDTHS[i]);
            ++i;
        }
        for (IFileTransfer fileTransfer : transfers.keySet()) {
            this.add((FileTransferEntry)transfers.get(fileTransfer));
        }
        this.makeActions();
        this.hookContextMenu();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setSize(1000, 1000);
    }

    private void add(FileTransferEntry transferEntry) {
        if (this.table != null && !this.table.isDisposed()) {
            this.viewer.add((Object)transferEntry);
        }
    }

    public void update(IFileTransfer transfer) {
        if (this.table != null && !this.table.isDisposed()) {
            FileTransferEntry entry = (FileTransferEntry)transfers.get(transfer);
            this.viewer.update((Object)entry, COLUMNS);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FileTransfersView.this.fillContextMenu(manager);
                FileTransfersView.this.enableActions();
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.table.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.launchAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resumeAction);
        manager.add((IAction)this.pauseAction);
        manager.add((IAction)this.removeAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.resumeAction = new Action(){

            public void run() {
                FileTransferEntry entry;
                IFileTransfer transfer;
                IFileTransferPausable pausable;
                ISelection sel = FileTransfersView.this.viewer.getSelection();
                if (!(sel instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection ssel = (IStructuredSelection)sel;
                Object o = ssel.getFirstElement();
                if (o instanceof FileTransferEntry && (pausable = (IFileTransferPausable)(transfer = (entry = (FileTransferEntry)o).getFileTransfer()).getAdapter(IFileTransferPausable.class)) != null) {
                    pausable.resume();
                }
            }
        };
        this.resumeAction.setId("resume");
        this.resumeAction.setText(Messages.getString("FileTransfersView_MENU_RESUME_TEXT"));
        this.pauseAction = new Action(){

            public void run() {
                FileTransferEntry entry;
                IFileTransfer transfer;
                IFileTransferPausable pausable;
                ISelection sel = FileTransfersView.this.viewer.getSelection();
                if (!(sel instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection ssel = (IStructuredSelection)sel;
                Object o = ssel.getFirstElement();
                if (o instanceof FileTransferEntry && (pausable = (IFileTransferPausable)(transfer = (entry = (FileTransferEntry)o).getFileTransfer()).getAdapter(IFileTransferPausable.class)) != null) {
                    pausable.pause();
                }
            }
        };
        this.pauseAction.setText(Messages.getString("FileTransfersView_MENU_PAUSE_TEXT"));
        this.removeAction = new Action(){

            public void run() {
                ISelection sel = FileTransfersView.this.viewer.getSelection();
                if (!(sel instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection ssel = (IStructuredSelection)sel;
                Object o = ssel.getFirstElement();
                if (o instanceof FileTransferEntry) {
                    FileTransferEntry entry = (FileTransferEntry)o;
                    IFileTransfer transfer = entry.getFileTransfer();
                    transfer.cancel();
                    FileTransfersView.this.viewer.remove((Object)entry);
                    transfers.remove(entry);
                }
            }
        };
        this.removeAction.setText(Messages.getString("FileTransfersView_MENU_REMOVE_TEXT"));
        this.removeAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.launchAction = new Action(){

            public void run() {
                ISelection sel = FileTransfersView.this.viewer.getSelection();
                if (!(sel instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection ssel = (IStructuredSelection)sel;
                Object o = ssel.getFirstElement();
                if (o != null && o instanceof FileTransferEntry) {
                    FileTransferEntry entry = (FileTransferEntry)o;
                    String fileName = entry.getLocalFileName();
                    Program.launch((String)fileName);
                }
            }
        };
        this.launchAction.setText(Messages.getString("FileTransfersView_MENU_LAUNCH_TEXT"));
    }

    void enableActions() {
        ISelection is = this.viewer.getSelection();
        this.resumeAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        if (is instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)is;
            this.removeAction.setEnabled(!iss.isEmpty());
            Object o = iss.getFirstElement();
            if (o instanceof FileTransferEntry) {
                FileTransferEntry entry = (FileTransferEntry)o;
                IFileTransfer transfer = entry.getFileTransfer();
                String localFileName = entry.getLocalFileName();
                if (transfer instanceof IIncomingFileTransfer && transfer.isDone() && transfer.getException() == null && localFileName != null) {
                    this.launchAction.setEnabled(true);
                }
                IFileTransferPausable pausable = (IFileTransferPausable)transfer.getAdapter(IFileTransferPausable.class);
                if (!transfer.isDone() && pausable != null) {
                    this.resumeAction.setEnabled(true);
                    this.pauseAction.setEnabled(true);
                    return;
                }
            }
        }
    }

    public void setFocus() {
        this.table.setFocus();
    }

    String showTransferRate(long startTime, double bytesReceived) {
        String unit;
        double convertedSize;
        double size = bytesReceived / ((double)(System.currentTimeMillis() + 1L - startTime) / 1000.0);
        if (size / 1.073741824E9 >= 1.0) {
            convertedSize = size / 1.073741824E9;
            unit = Messages.getString("FileTransfersView_GB");
        } else if (size / 1048576.0 >= 1.0) {
            convertedSize = size / 1048576.0;
            unit = Messages.getString("FileTransfersView_MB");
        } else if (size / 1024.0 >= 1.0) {
            convertedSize = size / 1024.0;
            unit = Messages.getString("FileTransfersView_KB");
        } else {
            convertedSize = size;
            unit = Messages.getString("FileTransfersView_BYTES");
        }
        DecimalFormat df = new DecimalFormat(NLS.bind((String)"0.00 {0}/s", (Object)unit));
        return df.format(convertedSize);
    }

    static class FileTransferEntry {
        IFileTransfer fileTransfer;
        String localFileName;
        long startTime;

        public FileTransferEntry(IFileTransfer fileTransfer, String localFileName) {
            this.fileTransfer = fileTransfer;
            this.localFileName = localFileName;
            this.startTime = System.currentTimeMillis();
        }

        public FileTransferEntry(IFileTransfer fileTransfer) {
            this(fileTransfer, null);
        }

        public IFileTransfer getFileTransfer() {
            return this.fileTransfer;
        }

        public String getLocalFileName() {
            return this.localFileName;
        }

        public long getStartTime() {
            return this.startTime;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return EMPTY_ARRAY;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        String endTime = null;

        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (!(obj instanceof FileTransferEntry)) {
                return this.getText(obj);
            }
            FileTransferEntry entry = (FileTransferEntry)obj;
            IFileTransfer transfer = entry.getFileTransfer();
            switch (index) {
                case 0: {
                    return transfer.getID().getName();
                }
                case 1: {
                    if (transfer instanceof IIncomingFileTransfer) {
                        return FileTransfersView.getTwoDigitNumber(((IIncomingFileTransfer)transfer).getBytesReceived());
                    }
                    return Messages.getString("FileTransfersView_NA");
                }
                case 2: {
                    if (transfer instanceof IOutgoingFileTransfer) {
                        return FileTransfersView.getTwoDigitNumber(((IOutgoingFileTransfer)transfer).getBytesSent());
                    }
                    return Messages.getString("FileTransfersView_NA");
                }
                case 3: {
                    String fileName = entry.getLocalFileName();
                    return fileName == null ? "" : fileName;
                }
                case 4: {
                    if (transfer.isDone()) {
                        Exception e = transfer.getException();
                        return e == null ? Messages.getString("FileTransfersView_YES") : Messages.getString("FileTransfersView_ERROR");
                    }
                    double percentComplete = transfer.getPercentComplete();
                    return Double.toString(percentComplete + 37.0);
                }
                case 5: {
                    return SDF.format(new Date(entry.getStartTime()));
                }
                case 6: {
                    if (transfer.isDone()) {
                        if (this.endTime == null) {
                            this.endTime = SDF.format(new Date());
                        }
                        return this.endTime;
                    }
                    return Messages.getString("FileTransfersView_IN_PROGRESS");
                }
                case 7: {
                    long fileLength = transfer.getFileLength();
                    if (fileLength == -1L) {
                        return Messages.getString("FileTransfersView_NA");
                    }
                    return FileTransfersView.this.showTransferRate(entry.getStartTime(), (double)fileLength * transfer.getPercentComplete());
                }
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

