/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.filetransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IOutgoingFileTransfer;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferResponseEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferSendDoneEvent;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.eclipse.osgi.util.NLS;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferManager;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;

public class XMPPOutgoingFileTransfer
implements IOutgoingFileTransfer {
    private final ID sessionID;
    private final XMPPID remoteTarget;
    private final IFileTransferListener listener;
    private File localFile;
    private long fileSize;
    private final OutgoingFileTransfer outgoingFileTransfer;
    private FileTransfer.Status status;
    private Exception exception;
    private int originalOutputRequestTimeout = -1;
    private boolean localCancelled = false;

    public XMPPOutgoingFileTransfer(FileTransferManager manager, XMPPID remoteTarget, IFileTransferInfo fileTransferInfo, IFileTransferListener listener, int outgoingRequestTimeout) {
        this.remoteTarget = remoteTarget;
        this.listener = listener;
        this.sessionID = this.createSessionID();
        String fullyQualifiedName = remoteTarget.getFQName();
        if (outgoingRequestTimeout != -1) {
            this.originalOutputRequestTimeout = OutgoingFileTransfer.getResponseTimeout();
            OutgoingFileTransfer.setResponseTimeout((int)outgoingRequestTimeout);
        }
        this.outgoingFileTransfer = manager.createOutgoingFileTransfer(fullyQualifiedName);
    }

    private ID createSessionID() {
        try {
            return IDFactory.getDefault().createGUID();
        }
        catch (IDCreateException e) {
            throw new NullPointerException("cannot create id for XMPPOutgoingFileTransfer");
        }
    }

    public synchronized ID getRemoteTargetID() {
        return this.remoteTarget;
    }

    public ID getID() {
        return this.sessionID;
    }

    private void fireTransferListenerEvent(IFileTransferEvent event) {
        this.listener.handleTransferEvent(event);
    }

    private void setStatus(FileTransfer.Status s) {
        this.status = s;
    }

    private void setException(Exception e) {
        this.exception = e;
    }

    private FileTransfer.Status getStatus() {
        return this.status;
    }

    private void setErrorStatus(Exception e) {
        this.setStatus(FileTransfer.Status.error);
        this.setException(e);
    }

    public synchronized void startSend(File localFile, String description) throws XMPPException {
        this.localFile = localFile;
        this.fileSize = localFile.length();
        this.setStatus(FileTransfer.Status.initial);
        this.outgoingFileTransfer.sendFile(localFile, description);
        Thread transferThread = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                block14: {
                    XMPPOutgoingFileTransfer.this.setStatus(XMPPOutgoingFileTransfer.this.outgoingFileTransfer.getStatus());
                    boolean negotiation = true;
                    while (negotiation && !XMPPOutgoingFileTransfer.this.localCancelled) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            XMPPOutgoingFileTransfer.this.setErrorStatus(e);
                            if (XMPPOutgoingFileTransfer.this.originalOutputRequestTimeout != -1) {
                                OutgoingFileTransfer.setResponseTimeout((int)XMPPOutgoingFileTransfer.this.originalOutputRequestTimeout);
                            }
                            XMPPOutgoingFileTransfer.this.fireTransferListenerEvent((IFileTransferEvent)new IOutgoingFileTransferSendDoneEvent(){

                                public IOutgoingFileTransfer getSource() {
                                    return XMPPOutgoingFileTransfer.this;
                                }

                                public String toString() {
                                    StringBuffer buf = new StringBuffer("IOutgoingFileTransferSendDoneEvent[");
                                    buf.append("isDone=" + this.getSource().isDone());
                                    buf.append(";bytesSent=").append(this.getSource().getBytesSent());
                                    buf.append(";exception=").append(XMPPOutgoingFileTransfer.this.getException()).append("]");
                                    return buf.toString();
                                }
                            });
                            return;
                        }
                        FileTransfer.Status s = XMPPOutgoingFileTransfer.this.outgoingFileTransfer.getStatus();
                        XMPPOutgoingFileTransfer.this.setStatus(s);
                        final boolean negotiated = XMPPOutgoingFileTransfer.this.getStatus().equals((Object)FileTransfer.Status.negotiated);
                        if (!s.equals((Object)FileTransfer.Status.negotiated) && !s.equals((Object)FileTransfer.Status.cancelled) && !s.equals((Object)FileTransfer.Status.complete) && !s.equals((Object)FileTransfer.Status.error) && !s.equals((Object)FileTransfer.Status.refused)) continue;
                        XMPPOutgoingFileTransfer.this.fireTransferListenerEvent((IFileTransferEvent)new IOutgoingFileTransferResponseEvent(){

                            public boolean requestAccepted() {
                                return negotiated;
                            }

                            public IOutgoingFileTransfer getSource() {
                                return XMPPOutgoingFileTransfer.this;
                            }

                            public String toString() {
                                StringBuffer buf = new StringBuffer("OutgoingFileTransferResponseEvent[");
                                buf.append("requestAccepted=").append(this.requestAccepted()).append("]");
                                return buf.toString();
                            }

                            public void setFileTransferJob(FileTransferJob job) {
                            }
                        });
                        negotiation = false;
                    }
                    if (!XMPPOutgoingFileTransfer.this.localCancelled) break block14;
                    XMPPOutgoingFileTransfer.this.setErrorStatus((Exception)new UserCancelledException("Transfer cancelled by sender"));
                    if (XMPPOutgoingFileTransfer.this.originalOutputRequestTimeout != -1) {
                        OutgoingFileTransfer.setResponseTimeout((int)XMPPOutgoingFileTransfer.this.originalOutputRequestTimeout);
                    }
                    XMPPOutgoingFileTransfer.this.fireTransferListenerEvent((IFileTransferEvent)new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                try {
                    try {
                        XMPPOutgoingFileTransfer.this.outgoingFileTransfer.sendStream((InputStream)new FileInputStream(XMPPOutgoingFileTransfer.this.localFile), XMPPOutgoingFileTransfer.this.localFile.getName(), XMPPOutgoingFileTransfer.this.fileSize, "Ein File");
                        XMPPOutgoingFileTransfer.this.setStatus(FileTransfer.Status.complete);
                    }
                    catch (Exception e) {
                        XMPPOutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                        XMPPOutgoingFileTransfer.this.setException(e);
                        if (XMPPOutgoingFileTransfer.this.originalOutputRequestTimeout != -1) {
                            OutgoingFileTransfer.setResponseTimeout((int)XMPPOutgoingFileTransfer.this.originalOutputRequestTimeout);
                        }
                        XMPPOutgoingFileTransfer.this.fireTransferListenerEvent((IFileTransferEvent)new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    if (XMPPOutgoingFileTransfer.this.originalOutputRequestTimeout != -1) {
                        OutgoingFileTransfer.setResponseTimeout((int)XMPPOutgoingFileTransfer.this.originalOutputRequestTimeout);
                    }
                    XMPPOutgoingFileTransfer.this.fireTransferListenerEvent((IFileTransferEvent)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                if (XMPPOutgoingFileTransfer.this.originalOutputRequestTimeout != -1) {
                    OutgoingFileTransfer.setResponseTimeout((int)XMPPOutgoingFileTransfer.this.originalOutputRequestTimeout);
                }
                XMPPOutgoingFileTransfer.this.fireTransferListenerEvent((IFileTransferEvent)new /* invalid duplicate definition of identical inner class */);
            }
        }, NLS.bind((String)"XMPP send {0}", (Object)this.remoteTarget.toExternalForm()));
        transferThread.start();
    }

    public synchronized void cancel() {
        this.localCancelled = true;
    }

    public synchronized File getLocalFile() {
        return this.localFile;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = XmppPlugin.getDefault().getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public long getBytesSent() {
        return this.outgoingFileTransfer.getBytesSent();
    }

    public Exception getException() {
        return this.exception;
    }

    public double getPercentComplete() {
        return this.fileSize <= 0L ? 1.0 : (double)this.outgoingFileTransfer.getAmountWritten() / (double)this.fileSize;
    }

    public boolean isDone() {
        return this.status == FileTransfer.Status.cancelled || this.status == FileTransfer.Status.error || this.status == FileTransfer.Status.complete;
    }

    public ID getSessionID() {
        return this.sessionID;
    }

    public long getFileLength() {
        return this.fileSize;
    }
}

