/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.server.generic;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.util.AdapterManagerTracker;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceContainerAdapterFactory;
import org.eclipse.ecf.server.generic.GenericServerContainer;
import org.eclipse.ecf.server.generic.GenericServerContainerGroupFactory;
import org.eclipse.ecf.server.generic.IGenericServerContainerGroupFactory;
import org.eclipse.ecf.server.generic.SSLGenericServerContainer;
import org.eclipse.ecf.server.generic.ServerManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.server.generic";
    private static Activator plugin;
    private BundleContext context = null;
    private ServerManager serverManager = null;
    private ServiceTracker discoveryTracker = null;
    private ServiceTracker logServiceTracker = null;
    private ServiceTracker containerManagerTracker = null;
    private GenericServerContainerGroupFactory gscgFactory = null;
    private ServiceRegistration gscgRegistration;

    public BundleContext getContext() {
        return this.context;
    }

    public IDiscoveryAdvertiser getDiscovery() {
        return (IDiscoveryAdvertiser)this.discoveryTracker.getService();
    }

    public IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            this.containerManagerTracker = new ServiceTracker(this.context, IContainerManager.class.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }

    public Bundle getBundle() {
        if (this.context == null) {
            return null;
        }
        return this.context.getBundle();
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void start(BundleContext ctxt) throws Exception {
        this.context = ctxt;
        plugin = this;
        this.discoveryTracker = new ServiceTracker(ctxt, IDiscoveryAdvertiser.class.getName(), null);
        this.discoveryTracker.open();
        try {
            this.serverManager = new ServerManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.gscgFactory = new GenericServerContainerGroupFactory();
        this.gscgRegistration = this.context.registerService(IGenericServerContainerGroupFactory.class.getName(), (Object)this.gscgFactory, null);
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(this.context){

            protected void runWithoutRegistry() throws Exception {
                AdapterManagerTracker t = new AdapterManagerTracker(this.getContext());
                t.open();
                IAdapterManager am = t.getAdapterManager();
                t.close();
                if (am != null) {
                    am.registerAdapters((IAdapterFactory)new RemoteServiceContainerAdapterFactory(), GenericServerContainer.class);
                    am.registerAdapters((IAdapterFactory)new RemoteServiceContainerAdapterFactory(), SSLGenericServerContainer.class);
                }
            }
        });
    }

    public void stop(BundleContext ctxt) throws Exception {
        if (this.serverManager != null) {
            this.serverManager.closeServers();
            this.serverManager = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
        }
        if (this.discoveryTracker != null) {
            this.discoveryTracker.close();
            this.discoveryTracker = null;
        }
        if (this.gscgRegistration != null) {
            this.gscgRegistration.unregister();
            this.gscgRegistration = null;
            if (this.gscgFactory != null) {
                this.gscgFactory.close();
                this.gscgFactory = null;
            }
        }
        plugin = null;
        this.context = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            throw new NullPointerException("Default Activator is null");
        }
        return plugin;
    }

    public static void log(String message) {
        Activator.getDefault().log((IStatus)new Status(1, Activator.getDefault().getBundle().getSymbolicName(), 1, message, null));
    }

    public static void log(String message, Throwable e) {
        Activator.getDefault().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 4, message, e));
    }
}

