/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui.chatroom;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.ui.chatroom.IMessageRenderer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class MessageRenderer
implements IMessageRenderer {
    protected static final String SENT_COLOR = "org.eclipse.ecf.presence.ui.sentColor";
    protected static final String SENT_FONT = "org.eclipse.ecf.presence.ui.sentFont";
    protected static final String RECEIVED_COLOR = "org.eclipse.ecf.presence.ui.receivedColor";
    protected static final String RECEIVED_FONT = "org.eclipse.ecf.presence.ui.receivedFont";
    protected static final String SYSTEM_COLOR = "org.eclipse.ecf.presence.ui.systemColor";
    protected static final String SYSTEM_FONT = "org.eclipse.ecf.presence.ui.systemFont";
    protected static final String RECEIVEDHIGHLIGHT_COLOR = "org.eclipse.ecf.presence.ui.receivedHighlightColor";
    protected static final String RECEIVEDHIGHLIGHT_FONT = "org.eclipse.ecf.presence.ui.receivedHighlightFont";
    protected static final String DATE_COLOR = "org.eclipse.ecf.presence.ui.dateColor";
    protected static final String DATE_FONT = "org.eclipse.ecf.presence.ui.dateFont";
    protected static final String DEFAULT_TIME_FORMAT = Messages.MessageRenderer_DEFAULT_TIME_FORMAT;
    protected static final String DEFAULT_DATE_FORMAT = Messages.MessageRenderer_DEFAULT_DATE_FORMAT;
    private StringBuffer buffer;
    private List styleRanges = new ArrayList();
    protected boolean nickContained;
    protected boolean isSent;
    protected String message;
    protected String originator;
    private String font;
    private String color;

    public StyleRange[] getStyleRanges() {
        return this.styleRanges.toArray(new StyleRange[this.styleRanges.size()]);
    }

    public String render(String msg, String orig, String localUserName) {
        Assert.isNotNull((Object)localUserName);
        this.styleRanges.clear();
        if (msg == null) {
            return null;
        }
        this.buffer = new StringBuffer();
        this.message = msg;
        this.originator = orig;
        this.nickContained = msg.indexOf(localUserName) != -1 && !localUserName.equals(orig);
        boolean bl = this.isSent = orig != null && orig.equals(localUserName);
        if (orig == null) {
            this.color = SYSTEM_COLOR;
            this.font = SYSTEM_FONT;
        } else if (this.isSent) {
            this.color = SENT_COLOR;
            this.font = SENT_FONT;
        } else if (this.nickContained) {
            this.color = RECEIVEDHIGHLIGHT_COLOR;
            this.font = RECEIVEDHIGHLIGHT_FONT;
        } else {
            this.color = RECEIVED_COLOR;
            this.font = RECEIVED_FONT;
        }
        this.doRender();
        return this.buffer.toString();
    }

    protected void doRender() {
        this.appendDateTime();
        if (this.originator != null) {
            this.appendNickname();
        }
        this.appendMessage();
    }

    protected void appendDateTime() {
        String msg = String.valueOf(NLS.bind((String)Messages.MessageRenderer_DEFAULT_DATETIME_FORMAT, (Object)this.getCurrentDate(DEFAULT_TIME_FORMAT))) + " ";
        this.append(msg, DATE_COLOR, null, DATE_FONT);
    }

    protected void appendNickname() {
        String msg = String.valueOf(this.originator) + ": ";
        this.append(msg, this.color, null, this.font);
    }

    protected void appendMessage() {
        this.append(this.message, this.color, null, this.font);
    }

    protected void append(String msg, String foreground, String background, String font1) {
        if (msg == null) {
            return;
        }
        int start = this.buffer.length();
        this.buffer.append(msg);
        if (foreground == null && background == null && font1 == null) {
            return;
        }
        StyleRange styleRange = new StyleRange(start, msg.length(), this.getColor(foreground), this.getColor(background));
        styleRange.font = this.getFont(font1);
        this.styleRanges.add(styleRange);
    }

    private Color getColor(String name) {
        if (name == null) {
            return null;
        }
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        Color c = theme.getColorRegistry().get(name);
        if (c == null) {
            return Display.getDefault().getSystemColor(2);
        }
        return c;
    }

    private Font getFont(String name) {
        if (name == null) {
            return null;
        }
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        Font f = theme.getFontRegistry().get(name);
        if (f == null) {
            return Display.getDefault().getSystemFont();
        }
        return f;
    }

    protected String getCurrentDate(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String res = sdf.format(new Date());
        return res;
    }

    protected String getDateTime() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getCurrentDate(DEFAULT_DATE_FORMAT)).append(" ").append(this.getCurrentDate(DEFAULT_TIME_FORMAT));
        return buf.toString();
    }
}

