/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.server.generic.GenericServerContainerGroup;
import org.eclipse.ecf.server.generic.GenericServerContainerGroupCreateException;
import org.eclipse.ecf.server.generic.IGenericServerContainerGroup;
import org.eclipse.ecf.server.generic.IGenericServerContainerGroupFactory;
import org.eclipse.ecf.server.generic.SSLGenericServerContainerGroup;

public class GenericServerContainerGroupFactory
implements IGenericServerContainerGroupFactory {
    private Hashtable serverContainerGroups = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGenericServerContainerGroup createContainerGroup(String hostname, int port, InetAddress bindAddress, Map defaultContainerProperties) throws GenericServerContainerGroupCreateException {
        Hashtable hashtable = this.serverContainerGroups;
        synchronized (hashtable) {
            SCGData scgdata = new SCGData(hostname, port, bindAddress);
            if (this.serverContainerGroups.contains(scgdata)) {
                throw new GenericServerContainerGroupCreateException("Cannot container group hostname=" + hostname + " port=" + port + " already exists");
            }
            IGenericServerContainerGroup scg = this.createGenericServerContainerGroup(scgdata, defaultContainerProperties);
            this.serverContainerGroups.put(scgdata, scg);
            return scg;
        }
    }

    @Override
    public IGenericServerContainerGroup createContainerGroup(String hostname, int port, Map defaultContainerProperties) throws GenericServerContainerGroupCreateException {
        return this.createContainerGroup(hostname, port, null, defaultContainerProperties);
    }

    protected boolean isSSLTransportSpecified(Map defaultContainerProperties) {
        boolean sslTransport = false;
        if (defaultContainerProperties != null) {
            Object sslTransportPropValue = defaultContainerProperties.get("org.eclipse.ecf.server.generic.containerProp.sslTransport");
            if (sslTransportPropValue instanceof Boolean) {
                sslTransport = (Boolean)sslTransportPropValue;
            } else if (sslTransportPropValue instanceof String) {
                sslTransport = Boolean.valueOf((String)sslTransportPropValue);
            }
        }
        return sslTransport;
    }

    protected IGenericServerContainerGroup createGenericServerContainerGroup(SCGData scgdata, Map defaultContainerProperties) throws GenericServerContainerGroupCreateException {
        if (this.isSSLTransportSpecified(defaultContainerProperties)) {
            return new SSLGenericServerContainerGroup(scgdata.getHostname(), scgdata.getPort(), scgdata.getBindAddress(), defaultContainerProperties);
        }
        return new GenericServerContainerGroup(scgdata.getHostname(), scgdata.getPort(), scgdata.getBindAddress(), defaultContainerProperties);
    }

    @Override
    public IGenericServerContainerGroup createContainerGroup(String hostname, int port) throws GenericServerContainerGroupCreateException {
        return this.createContainerGroup(hostname, port, null);
    }

    @Override
    public IGenericServerContainerGroup createContainerGroup(String hostname) throws GenericServerContainerGroupCreateException {
        return this.createContainerGroup(hostname, 3282);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Hashtable hashtable = this.serverContainerGroups;
        synchronized (hashtable) {
            for (SCGData scgdata : this.serverContainerGroups.keySet()) {
                IGenericServerContainerGroup scg = (IGenericServerContainerGroup)this.serverContainerGroups.get(scgdata);
                scg.close();
            }
        }
        this.serverContainerGroups.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGenericServerContainerGroup getContainerGroup(String hostname, int port) {
        if (hostname == null) {
            return null;
        }
        SCGData scgdata = new SCGData(hostname, port, null);
        Hashtable hashtable = this.serverContainerGroups;
        synchronized (hashtable) {
            return (IGenericServerContainerGroup)this.serverContainerGroups.get(scgdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGenericServerContainerGroup[] getContainerGroups() {
        ArrayList<IGenericServerContainerGroup> results = new ArrayList<IGenericServerContainerGroup>();
        Hashtable hashtable = this.serverContainerGroups;
        synchronized (hashtable) {
            for (SCGData scgdata : this.serverContainerGroups.keySet()) {
                IGenericServerContainerGroup gscg = (IGenericServerContainerGroup)this.serverContainerGroups.get(scgdata);
                if (gscg == null) continue;
                results.add(gscg);
            }
        }
        return results.toArray(new IGenericServerContainerGroup[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGenericServerContainerGroup removeContainerGroup(String hostname, int port) {
        if (hostname == null) {
            return null;
        }
        SCGData scgdata = new SCGData(hostname, port, null);
        Hashtable hashtable = this.serverContainerGroups;
        synchronized (hashtable) {
            return (IGenericServerContainerGroup)this.serverContainerGroups.remove(scgdata);
        }
    }

    protected class SCGData {
        private String hostname;
        private int port;
        private InetAddress bindAddress;

        public SCGData(String hostname, int port, InetAddress bindAddress) {
            Assert.isNotNull((Object)hostname);
            Assert.isTrue((port > 0 ? 1 : 0) != 0);
            this.hostname = hostname;
            this.port = port;
            this.bindAddress = bindAddress;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object other) {
            if (!(other instanceof SCGData)) {
                return false;
            }
            SCGData o = (SCGData)other;
            return this.hostname.equals(o.hostname) && this.port == o.port;
        }

        public int hashCode() {
            return this.hostname.hashCode() ^ this.port;
        }

        public InetAddress getBindAddress() {
            return this.bindAddress;
        }
    }
}

