/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservices.ui;

import java.lang.reflect.Method;

class RemoteMethod {
    private final Method method;
    private final Parameter[] parameters;
    private final Class[] parameterTypes;

    RemoteMethod(Method method) {
        this.method = method;
        this.parameterTypes = method.getParameterTypes();
        this.parameters = new Parameter[this.parameterTypes.length];
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = new Parameter(this.parameterTypes[i]);
            ++i;
        }
    }

    public String[] getParameterTypes() {
        String[] types = new String[this.parameterTypes.length];
        int i = 0;
        while (i < types.length) {
            String name = this.parameterTypes[i].getName();
            types[i] = name.charAt(0) == 'j' ? "String" : name;
            ++i;
        }
        return types;
    }

    Method getMethod() {
        return this.method;
    }

    Parameter[] getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        int index;
        String name = this.method.getReturnType().getName();
        if (name.startsWith("[L")) {
            name = name.substring(2, name.length() - 1).concat("[]");
        }
        if ((index = name.lastIndexOf(46)) != -1) {
            name = name.substring(index + 1);
        }
        name = name.replace('$', '.');
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSignature() {
        StringBuffer buffer;
        StringBuffer stringBuffer = buffer = new StringBuffer(this.method.getName());
        synchronized (stringBuffer) {
            buffer.append('(');
            String[] types = this.getParameterTypes();
            if (types.length != 0) {
                int i = 0;
                while (i < types.length) {
                    buffer.append(types[i]).append(", ");
                    ++i;
                }
                buffer.delete(buffer.length() - 2, buffer.length());
            }
            buffer.append(')');
            return buffer.toString();
        }
    }

    class Parameter {
        private final Class parameter;
        private String argument = "";

        Parameter(Class parameter) {
            this.parameter = parameter;
        }

        void setArgument(String argument) {
            this.argument = argument;
        }

        String getArgument() {
            return this.argument;
        }

        Class getParameter() {
            return this.parameter;
        }
    }
}

