/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ai.mcp.transports;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStringChannel {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStringChannel.class);
    public static final int DEFAULT_INBUFFER_SIZE = 1024;
    public static String DEFAULT_MESSAGE_DELIMITER = "\n";
    protected String messageDelimiter = DEFAULT_MESSAGE_DELIMITER;
    public static int DEFAULT_WRITE_TIMEOUT = 5000;
    protected int writeTimeout = DEFAULT_WRITE_TIMEOUT;
    public static int DEFAULT_CONNECT_TIMEOUT = 10000;
    protected int connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    public static int DEFAULT_TERMINATION_TIMEOUT = 2000;
    protected int terminationTimeout = DEFAULT_TERMINATION_TIMEOUT;
    protected final Selector selector;
    protected final ByteBuffer inBuffer;
    protected final ExecutorService executor;
    protected final Object writeLock = new Object();

    protected void setMessageDelimiter(String delim) {
        this.messageDelimiter = delim;
    }

    protected String getMessageDelimiter() {
        return this.messageDelimiter;
    }

    protected void setWriteTimeout(int timeout) {
        this.writeTimeout = timeout;
    }

    protected int getWriteTimeout() {
        return this.writeTimeout;
    }

    protected void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    protected int getConnectTimeout() {
        return this.connectTimeout;
    }

    protected void setTerminationTimeout(int timeout) {
        this.terminationTimeout = timeout;
    }

    protected int getTerminationTimeout() {
        return this.terminationTimeout;
    }

    public AbstractStringChannel(Selector selector, int incomingBufferSize, ExecutorService executor) {
        Objects.requireNonNull(selector, "Selector must not be null");
        this.selector = selector;
        this.inBuffer = ByteBuffer.allocate(incomingBufferSize);
        this.executor = executor == null ? Executors.newSingleThreadExecutor() : executor;
    }

    public AbstractStringChannel(Selector selector, int incomingBufferSize) {
        this(selector, incomingBufferSize, null);
    }

    public AbstractStringChannel(Selector selector) {
        this(selector, 1024);
    }

    public AbstractStringChannel() throws IOException {
        this(Selector.open());
    }

    protected Runnable getRunnableForProcessing(IOConsumer<SocketChannel> acceptHandler, IOConsumer<SocketChannel> connectHandler, IOConsumer<String> readHandler) {
        return () -> {
            SelectionKey key = null;
            try {
                block2: while (true) {
                    int count = this.selector.select();
                    this.debug("select returned count={}", count);
                    Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                    Iterator<SelectionKey> iter = selectedKeys.iterator();
                    while (true) {
                        if (!iter.hasNext()) continue block2;
                        key = iter.next();
                        if (key.isConnectable()) {
                            this.handleConnectable(key, connectHandler);
                        } else if (key.isAcceptable()) {
                            this.handleAcceptable(key, acceptHandler);
                        } else if (key.isReadable()) {
                            this.handleReadable(key, readHandler);
                        } else if (key.isWritable()) {
                            this.handleWritable(key);
                        }
                        iter.remove();
                    }
                    break;
                }
            }
            catch (Throwable e) {
                this.handleException(key, e);
                return;
            }
        };
    }

    public abstract void close();

    protected abstract void handleException(SelectionKey var1, Throwable var2);

    protected void start(IOConsumer<SocketChannel> acceptHandler, IOConsumer<SocketChannel> connectHandler, IOConsumer<String> readHandler) throws IOException {
        this.executor.execute(this.getRunnableForProcessing(acceptHandler, connectHandler, readHandler));
    }

    protected void debug(String format, Object ... o) {
        if (logger.isDebugEnabled()) {
            logger.debug(format, o);
        }
    }

    protected void handleConnectable(SelectionKey key, IOConsumer<SocketChannel> connectHandler) throws IOException {
        SocketChannel client = (SocketChannel)key.channel();
        this.debug("client={}", client);
        client.configureBlocking(false);
        client.register(this.selector, 1, new AttachedIO());
        if (client.isConnectionPending()) {
            client.finishConnect();
            this.debug("connected client={}", client);
        }
        if (connectHandler != null) {
            connectHandler.apply(client);
        }
    }

    protected void handleAcceptable(SelectionKey key, IOConsumer<SocketChannel> acceptHandler) throws IOException {
        ServerSocketChannel serverSocket = (ServerSocketChannel)key.channel();
        SocketChannel client = serverSocket.accept();
        this.debug("client={}", client);
        client.configureBlocking(false);
        client.register(this.selector, 1, new AttachedIO());
        this.configureAcceptSocketChannel(client);
        if (client.isConnectionPending()) {
            client.finishConnect();
            this.debug("accepted client={}", client);
        }
        if (acceptHandler != null) {
            acceptHandler.apply(client);
        }
    }

    protected void configureAcceptSocketChannel(SocketChannel client) throws IOException {
    }

    protected AttachedIO getAttachedIO(SelectionKey key) throws IOException {
        AttachedIO io = (AttachedIO)key.attachment();
        if (io == null) {
            throw new IOException("No AttachedIO object found on key");
        }
        return io;
    }

    protected void handleReadable(SelectionKey key, IOConsumer<String> readHandler) throws IOException {
        SocketChannel client = (SocketChannel)key.channel();
        AttachedIO io = this.getAttachedIO(key);
        this.debug("read client={}", client);
        int r = client.read(this.inBuffer);
        if (r == -1) {
            throw new IOException("Channel read reached end of stream");
        }
        this.inBuffer.flip();
        String partial = new String(this.inBuffer.array(), 0, r, StandardCharsets.UTF_8);
        StringBuffer sb = io.reading != null ? io.reading : new StringBuffer();
        sb.append(partial);
        if (partial.endsWith(this.messageDelimiter)) {
            String message = sb.toString();
            io.reading = null;
            this.debug("read client={} msg=", client, message);
            if (readHandler != null) {
                String[] messages = this.splitMessage(message);
                int i = 0;
                while (i < messages.length) {
                    readHandler.apply(messages[i]);
                    ++i;
                }
            }
        } else {
            io.reading = sb;
            this.debug("read partial={}", partial);
        }
        this.inBuffer.clear();
    }

    protected void handleWritable(SelectionKey key) throws IOException {
        ByteBuffer buf = this.getAttachedIO((SelectionKey)key).writing;
        SocketChannel client = (SocketChannel)key.channel();
        if (buf != null) {
            this.doWrite(key, client, buf, o -> {
                Object object = this.writeLock;
                synchronized (object) {
                    this.writeLock.notifyAll();
                }
            });
        }
    }

    protected void doWrite(SocketChannel client, String message, IOConsumer<Object> writeHandler) throws IOException {
        Objects.requireNonNull(client, "Client must not be null");
        Objects.requireNonNull(message, "Message must not be null");
        this.doWrite(client.keyFor(this.selector), client, ByteBuffer.wrap(message.getBytes(StandardCharsets.UTF_8)), writeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(SelectionKey key, SocketChannel client, ByteBuffer buf, IOConsumer<Object> writeHandler) throws IOException {
        AttachedIO io = (AttachedIO)key.attachment();
        Object object = this.writeLock;
        synchronized (object) {
            int written = client.write(buf);
            if (buf.hasRemaining()) {
                this.debug("doWrite written={}, remaining={}", written, buf.remaining());
                io.writing = buf.slice();
                key.interestOpsOr(4);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("doWrite message={}", (Object)new String(buf.array(), 0, written));
                }
                io.writing = null;
                key.interestOps(1);
                if (writeHandler != null) {
                    writeHandler.apply(null);
                }
            }
        }
    }

    protected void executorShutdown() {
        block3: {
            if (!this.executor.isShutdown()) {
                this.debug("shutdown", new Object[0]);
                try {
                    this.executor.awaitTermination(this.terminationTimeout, TimeUnit.MILLISECONDS);
                    this.executor.shutdown();
                }
                catch (InterruptedException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Exception in executor awaitTermination", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hardCloseClient(SocketChannel client, IOConsumer<SocketChannel> closeHandler) {
        if (client != null) {
            this.debug("hardClose client={}", client);
            Object object = this.writeLock;
            synchronized (object) {
                block7: {
                    try {
                        if (closeHandler != null) {
                            closeHandler.apply(client);
                        }
                        client.close();
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug("hardClose client socketchannel.close exception", (Throwable)e);
                    }
                }
            }
            this.executorShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMessageToChannel(SocketChannel client, String message) throws IOException {
        Objects.requireNonNull(client, "Client must not be null");
        Objects.requireNonNull(message, "Message must not be null");
        String outputMessage = message.replace("\r\n", "\\n").replace("\n", "\\n").replace("\r", "\\n").concat(DEFAULT_MESSAGE_DELIMITER);
        this.debug("writing msg={}", outputMessage);
        Object object = this.writeLock;
        synchronized (object) {
            this.doWrite(client, outputMessage, null);
            Buffer bufRemaining = null;
            long waitTime = System.currentTimeMillis() + (long)this.writeTimeout;
            while (waitTime - System.currentTimeMillis() > 0L) {
                bufRemaining = this.getAttachedIO((SelectionKey)client.keyFor((Selector)this.selector)).writing;
                if (bufRemaining == null || bufRemaining.remaining() == 0) break;
                try {
                    this.debug("writeBlocking WAITING(ms)={} msg={}", String.valueOf(waitTime / 10L), outputMessage);
                    this.writeLock.wait(waitTime / 10L);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("write message wait interrupted");
                }
            }
            if (bufRemaining != null && bufRemaining.remaining() > 0) {
                throw new IOException("Write not completed.  Non empty buffer remaining after timeout");
            }
        }
        this.debug("writing done msg={}", outputMessage);
    }

    protected void configureConnectSocketChannel(SocketChannel client, SocketAddress connectAddress) throws IOException {
    }

    protected String[] splitMessage(String message) {
        return message == null ? new String[]{} : message.split(this.messageDelimiter);
    }

    protected class AttachedIO {
        public ByteBuffer writing;
        public StringBuffer reading;

        protected AttachedIO() {
        }
    }

    @FunctionalInterface
    public static interface IOConsumer<T> {
        public void apply(T var1) throws IOException;
    }
}

