/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.UserAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Session;
import org.jivesoftware.smack.sasl.SASLAnonymous;
import org.jivesoftware.smack.sasl.SASLCramMD5Mechanism;
import org.jivesoftware.smack.sasl.SASLDigestMD5Mechanism;
import org.jivesoftware.smack.sasl.SASLExternalMechanism;
import org.jivesoftware.smack.sasl.SASLGSSAPIMechanism;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.SASLPlainMechanism;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SASLAuthentication
implements UserAuthentication {
    private static Map<String, Class> implementedMechanisms = new HashMap<String, Class>();
    private static List<String> mechanismsPreferences = new ArrayList<String>();
    private XMPPConnection connection;
    private Collection<String> serverMechanisms = new ArrayList<String>();
    private SASLMechanism currentMechanism = null;
    private boolean saslNegotiated;
    private boolean saslFailed;
    private boolean resourceBinded;
    private boolean sessionSupported;

    static {
        SASLAuthentication.registerSASLMechanism("EXTERNAL", SASLExternalMechanism.class);
        SASLAuthentication.registerSASLMechanism("GSSAPI", SASLGSSAPIMechanism.class);
        SASLAuthentication.registerSASLMechanism("DIGEST-MD5", SASLDigestMD5Mechanism.class);
        SASLAuthentication.registerSASLMechanism("CRAM-MD5", SASLCramMD5Mechanism.class);
        SASLAuthentication.registerSASLMechanism("PLAIN", SASLPlainMechanism.class);
        SASLAuthentication.registerSASLMechanism("ANONYMOUS", SASLAnonymous.class);
        SASLAuthentication.supportSASLMechanism("GSSAPI", 0);
        SASLAuthentication.supportSASLMechanism("DIGEST-MD5", 1);
        SASLAuthentication.supportSASLMechanism("CRAM-MD5", 2);
        SASLAuthentication.supportSASLMechanism("PLAIN", 3);
        SASLAuthentication.supportSASLMechanism("ANONYMOUS", 4);
    }

    public static void registerSASLMechanism(String name, Class mClass) {
        implementedMechanisms.put(name, mClass);
    }

    public static void unregisterSASLMechanism(String name) {
        implementedMechanisms.remove(name);
        mechanismsPreferences.remove(name);
    }

    public static void supportSASLMechanism(String name) {
        mechanismsPreferences.add(0, name);
    }

    public static void supportSASLMechanism(String name, int index) {
        mechanismsPreferences.add(index, name);
    }

    public static void unsupportSASLMechanism(String name) {
        mechanismsPreferences.remove(name);
    }

    public static List<Class> getRegisterSASLMechanisms() {
        ArrayList<Class> answer = new ArrayList<Class>();
        for (String mechanismsPreference : mechanismsPreferences) {
            answer.add(implementedMechanisms.get(mechanismsPreference));
        }
        return answer;
    }

    SASLAuthentication(XMPPConnection connection) {
        this.connection = connection;
        this.init();
    }

    public boolean hasAnonymousAuthentication() {
        return this.serverMechanisms.contains("ANONYMOUS");
    }

    public boolean hasNonAnonymousAuthentication() {
        return !this.serverMechanisms.isEmpty() && (this.serverMechanisms.size() != 1 || !this.hasAnonymousAuthentication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String authenticate(String username, String resource, CallbackHandler cbh) throws XMPPException {
        String selectedMechanism = null;
        for (String mechanism : mechanismsPreferences) {
            if (!implementedMechanisms.containsKey(mechanism) || !this.serverMechanisms.contains(mechanism)) continue;
            selectedMechanism = mechanism;
            break;
        }
        if (selectedMechanism == null) throw new XMPPException("SASL Authentication failed. No known authentication mechanisims.");
        try {
            Class mechanismClass = implementedMechanisms.get(selectedMechanism);
            Constructor constructor = mechanismClass.getConstructor(SASLAuthentication.class);
            this.currentMechanism = (SASLMechanism)constructor.newInstance(this);
            this.currentMechanism.authenticate(username, this.connection.getHost(), cbh);
            SASLAuthentication sASLAuthentication = this;
            synchronized (sASLAuthentication) {
                if (!this.saslNegotiated && !this.saslFailed) {
                    try {
                        this.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.saslFailed) {
                throw new XMPPException("SASL authentication failed using mechanism " + selectedMechanism);
            }
            if (!this.saslNegotiated) throw new XMPPException("SASL authentication failed");
            return this.bindResourceAndEstablishSession(resource);
        }
        catch (XMPPException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XMPPException("SASL authentication failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authenticate(String username, String password, String resource) throws XMPPException {
        String selectedMechanism = null;
        for (String mechanism : mechanismsPreferences) {
            if (!implementedMechanisms.containsKey(mechanism) || !this.serverMechanisms.contains(mechanism)) continue;
            selectedMechanism = mechanism;
            break;
        }
        if (selectedMechanism != null) {
            try {
                Class mechanismClass = implementedMechanisms.get(selectedMechanism);
                Constructor constructor = mechanismClass.getConstructor(SASLAuthentication.class);
                this.currentMechanism = (SASLMechanism)constructor.newInstance(this);
                this.currentMechanism.authenticate(username, this.connection.getServiceName(), password);
                SASLAuthentication sASLAuthentication = this;
                synchronized (sASLAuthentication) {
                    if (!this.saslNegotiated && !this.saslFailed) {
                        try {
                            this.wait(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.saslFailed) {
                    throw new XMPPException("SASL authentication failed using mechanism " + selectedMechanism);
                }
                if (this.saslNegotiated) {
                    return this.bindResourceAndEstablishSession(resource);
                }
                return new NonSASLAuthentication(this.connection).authenticate(username, password, resource);
            }
            catch (XMPPException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new NonSASLAuthentication(this.connection).authenticate(username, password, resource);
            }
        }
        return new NonSASLAuthentication(this.connection).authenticate(username, password, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authenticateAnonymously() throws XMPPException {
        try {
            this.currentMechanism = new SASLAnonymous(this);
            this.currentMechanism.authenticate(null, null, "");
            SASLAuthentication sASLAuthentication = this;
            synchronized (sASLAuthentication) {
                if (!this.saslNegotiated && !this.saslFailed) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.saslFailed) {
                throw new XMPPException("SASL authentication failed");
            }
            if (this.saslNegotiated) {
                return this.bindResourceAndEstablishSession(null);
            }
            return new NonSASLAuthentication(this.connection).authenticateAnonymously();
        }
        catch (IOException e) {
            return new NonSASLAuthentication(this.connection).authenticateAnonymously();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String bindResourceAndEstablishSession(String resource) throws XMPPException {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            if (!this.resourceBinded) {
                try {
                    this.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!this.resourceBinded) {
            throw new XMPPException("Resource binding not offered by server");
        }
        Bind bindResource = new Bind();
        bindResource.setResource(resource);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(bindResource.getPacketID()));
        this.connection.sendPacket(bindResource);
        Bind response = (Bind)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from the server.");
        }
        if (response.getType() == IQ.Type.ERROR) {
            throw new XMPPException(response.getError());
        }
        String userJID = response.getJid();
        if (this.sessionSupported) {
            Session session = new Session();
            collector = this.connection.createPacketCollector(new PacketIDFilter(session.getPacketID()));
            this.connection.sendPacket(session);
            IQ ack = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            collector.cancel();
            if (ack == null) {
                throw new XMPPException("No response from the server.");
            }
            if (ack.getType() == IQ.Type.ERROR) {
                throw new XMPPException(ack.getError());
            }
        } else {
            throw new XMPPException("Session establishment not offered by server");
        }
        return userJID;
    }

    void setAvailableSASLMethods(Collection<String> mechanisms) {
        this.serverMechanisms = mechanisms;
    }

    public boolean isAuthenticated() {
        return this.saslNegotiated;
    }

    void challengeReceived(String challenge) throws IOException {
        this.currentMechanism.challengeReceived(challenge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticated() {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.saslNegotiated = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticationFailed() {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.saslFailed = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindingRequired() {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.resourceBinded = true;
            this.notify();
        }
    }

    public void send(String stanza) throws IOException {
        this.connection.writer.write(stanza);
        this.connection.writer.flush();
    }

    void sessionsSupported() {
        this.sessionSupported = true;
    }

    protected void init() {
        this.saslNegotiated = false;
        this.saslFailed = false;
        this.resourceBinded = false;
        this.sessionSupported = false;
    }
}

