/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.examples.internal.remoteservices.hello.consumer2;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.examples.remoteservices.hello.HelloMessage;
import org.eclipse.ecf.examples.remoteservices.hello.IHello;
import org.eclipse.ecf.examples.remoteservices.hello.IHelloAsync;
import org.eclipse.ecf.osgi.services.distribution.IDistributionConstants;
import org.eclipse.ecf.remoteservice.IAsyncCallback;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
IDistributionConstants {
    private static BundleContext context;
    private ServiceTracker<IHello, IHello> helloServiceTracker;
    private static final String CONSUMER_NAME = "slewis";

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.helloServiceTracker = new ServiceTracker(context, this.createFilter(), (ServiceTrackerCustomizer)new HelloTrackerCustomizer());
        this.helloServiceTracker.open();
    }

    private Filter createFilter() throws InvalidSyntaxException {
        return context.createFilter("(&(objectClass=" + IHello.class.getName() + ")(" + "service.imported" + "=*))");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.helloServiceTracker != null) {
            this.helloServiceTracker.close();
            this.helloServiceTracker = null;
        }
        context = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HelloTrackerCustomizer
    implements ServiceTrackerCustomizer<IHello, IHello> {
        HelloTrackerCustomizer() {
        }

        public IHello addingService(ServiceReference<IHello> reference) {
            IHello proxy = (IHello)context.getService(reference);
            this.useHelloService(proxy);
            return proxy;
        }

        private void useHelloService(IHello proxy) {
            System.out.println("STARTING remote call via proxy...");
            proxy.hello("slewis via proxy");
            System.out.println("COMPLETED remote call via proxy");
            System.out.println();
            System.out.println("STARTING remote call via proxy...");
            proxy.helloMessage(new HelloMessage("slewis via proxy", "howdy"));
            System.out.println("COMPLETED remote call via proxy");
            System.out.println();
            if (proxy instanceof IHelloAsync) {
                Object result;
                IHelloAsync helloA = (IHelloAsync)proxy;
                IAsyncCallback<String> callback = new IAsyncCallback<String>(){

                    public void onSuccess(String result) {
                        System.out.println("COMPLETED remote call with callback SUCCESS with result=" + result);
                        System.out.println();
                    }

                    public void onFailure(Throwable t) {
                        System.out.println("COMPLETED remote call with callback FAILED with exception=" + t);
                        System.out.println();
                    }
                };
                System.out.println("STARTING async remote call via callback...");
                helloA.helloAsync("slewis via async proxy with listener", (IAsyncCallback)callback);
                System.out.println("LOCAL async invocation complete");
                System.out.println();
                System.out.println("STARTING async remote call via future...");
                IFuture future = helloA.helloAsync("slewis via async proxy with future");
                System.out.println("LOCAL async future invocation complete");
                System.out.println();
                try {
                    while (!future.isDone()) {
                        System.out.println("LOCAL future not yet done...so we're doing other stuff while waiting for future to be done");
                        Thread.sleep(200L);
                    }
                    result = future.get();
                    System.out.println("COMPLETED remote call with future SUCCEEDED with result=" + result);
                    System.out.println();
                }
                catch (OperationCanceledException e) {
                    System.out.println("COMPLETED remote call with callback CANCELLED with exception=" + (Object)((Object)e));
                    System.out.println();
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    System.out.println("COMPLETED remote call with callback INTERRUPTED with exception=" + e);
                    System.out.println();
                    e.printStackTrace();
                }
                System.out.println("STARTING async remote call via callback...");
                helloA.helloMessageAsync(new HelloMessage("slewis via async proxy with listener", "howdy"), (IAsyncCallback)callback);
                System.out.println("LOCAL async invocation complete");
                System.out.println();
                System.out.println("STARTING async remote call via future...");
                future = helloA.helloMessageAsync(new HelloMessage("slewis via async proxy with future", "howdy"));
                System.out.println("LOCAL async future invocation complete");
                System.out.println();
                try {
                    while (!future.isDone()) {
                        System.out.println("LOCAL future not yet done...so we're doing other stuff while waiting for future to be done");
                        Thread.sleep(200L);
                    }
                    result = future.get();
                    System.out.println("COMPLETED remote call with future SUCCEEDED with result=" + result);
                    System.out.println();
                }
                catch (OperationCanceledException e) {
                    System.out.println("COMPLETED remote call with callback CANCELLED with exception=" + (Object)((Object)e));
                    System.out.println();
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    System.out.println("COMPLETED remote call with callback INTERRUPTED with exception=" + e);
                    System.out.println();
                    e.printStackTrace();
                }
            }
        }

        public void modifiedService(ServiceReference<IHello> reference, IHello service) {
        }

        public void removedService(ServiceReference<IHello> reference, IHello service) {
        }
    }
}

