/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.comm.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.ProviderPlugin;
import org.eclipse.ecf.provider.comm.tcp.ISocketAcceptHandler;

public class Server
extends ServerSocket {
    public static final int DEFAULT_BACKLOG = 50;
    ISocketAcceptHandler acceptHandler;
    Thread listenerThread;
    ThreadGroup threadGroup;
    static /* synthetic */ Class class$0;

    protected void debug(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/connection", (String)msg);
    }

    protected void traceStack(String msg, Throwable e) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.comm.tcp.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", (Class)clazz, (String)msg, (Throwable)e);
    }

    public Server(ThreadGroup group, int port, int backlog, InetAddress bindAddress, ISocketAcceptHandler handler) throws IOException {
        super(port, backlog, bindAddress);
        if (handler == null) {
            throw new NullPointerException("Socket accept handler cannot be null");
        }
        this.acceptHandler = handler;
        this.threadGroup = group;
        this.listenerThread = this.setupListener();
        this.listenerThread.start();
    }

    public Server(ThreadGroup group, int port, InetAddress bindAddress, ISocketAcceptHandler handler) throws IOException {
        this(group, port, 50, bindAddress, handler);
    }

    public Server(ThreadGroup group, int port, int backlog, ISocketAcceptHandler handler) throws IOException {
        this(null, port, backlog, null, handler);
    }

    public Server(ThreadGroup group, int port, ISocketAcceptHandler handler) throws IOException {
        this(group, port, 50, handler);
    }

    public Server(int port, ISocketAcceptHandler handler) throws IOException {
        this(null, port, handler);
    }

    protected Thread setupListener() {
        return new Thread(this.threadGroup, new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Server.this.handleAccept(Server.this.accept());
                    }
                }
                catch (Exception e) {
                    Server.this.traceStack("Exception in accept", e);
                    Server.this.debug("Closing listener normally.");
                    return;
                }
            }
        }, "ServerApplication(" + this.getLocalPort() + ")");
    }

    protected void handleAccept(final Socket aSocket) {
        new Thread(this.threadGroup, new Runnable(){

            public void run() {
                try {
                    Server.this.debug("accept:" + aSocket.getInetAddress());
                    Server.this.acceptHandler.handleAccept(aSocket);
                }
                catch (Exception e) {
                    Server.this.traceStack("Unexpected exception in handleAccept...closing", e);
                    try {
                        aSocket.close();
                    }
                    catch (IOException e1) {
                        ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", 4, "accept.close", (Throwable)e1));
                    }
                }
            }
        }).start();
    }

    public synchronized void close() throws IOException {
        super.close();
        if (this.listenerThread != null) {
            this.listenerThread.interrupt();
            this.listenerThread = null;
        }
        if (this.threadGroup != null) {
            this.threadGroup.interrupt();
            this.threadGroup = null;
        }
        this.acceptHandler = null;
    }
}

