/*
 * Decompiled with CFR 0.152.
 */
package com.mycorp.examples.timeservice.internal.provider.rest.host;

import com.mycorp.examples.timeservice.ITimeService;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.remoteservice.servlet.HttpServiceComponent;
import org.eclipse.ecf.remoteservice.servlet.RemoteServiceHttpServlet;
import org.eclipse.ecf.remoteservice.servlet.ServletServerContainer;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.http.HttpService;

public class TimeServiceServerContainer
extends ServletServerContainer {
    public static final String TIMESERVICE_HOST_CONFIG_NAME = "com.mycorp.examples.timeservice.rest.host";
    public static final String TIMESERVICE_SERVLET_NAME = "/" + ITimeService.class.getName();
    private final HttpService httpService;

    TimeServiceServerContainer(String id, HttpService httpService) throws ContainerCreateException {
        super(IDFactory.getDefault().createID("com.mycorp.examples.timeservice.provider.rest.namespace", id));
        this.httpService = httpService;
        try {
            this.httpService.registerServlet(TIMESERVICE_SERVLET_NAME, (Servlet)new TimeRemoteServiceHttpServlet(), null, null);
        }
        catch (Exception e) {
            throw new ContainerCreateException("Could not create Time Service Server Container", (Throwable)e);
        }
    }

    public void dispose() {
        this.httpService.unregister(TIMESERVICE_SERVLET_NAME);
        super.dispose();
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName("com.mycorp.examples.timeservice.provider.rest.namespace");
    }

    class TimeRemoteServiceHttpServlet
    extends RemoteServiceHttpServlet {
        private static final long serialVersionUID = 3906126401901826462L;

        TimeRemoteServiceHttpServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            ITimeService timeService = (ITimeService)HttpServiceComponent.getDefault().getService(ITimeService.class);
            Long currentTime = timeService.getCurrentTime();
            try {
                resp.getOutputStream().print(new JSONObject().put("time", (Object)currentTime).toString());
            }
            catch (JSONException e) {
                throw new ServletException("json response object could not be created for time service", (Throwable)e);
            }
        }
    }
}

