/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservices.rest.rss;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndPerson;
import java.util.Dictionary;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.IRemoteResponseDeserializer;
import org.eclipse.ecf.remoteservice.client.IRemoteServiceClientContainerAdapter;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.ecf.remoteservice.rest.IRestCall;
import org.eclipse.ecf.remoteservice.rest.RestCallFactory;
import org.eclipse.ecf.remoteservice.rest.RestCallableFactory;
import org.eclipse.ecf.remoteservice.rest.client.AbstractRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpGetRequestType;
import org.eclipse.ecf.remoteservice.rest.identity.RestNamespace;
import org.eclipse.ecf.remoteservice.rest.synd.SyndFeedResponseDeserializer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final String REST_CONTAINER_TYPE = "ecf.rest.client";
    private static final String RSS_URL = "http://planeteclipse.org";
    private static final String RSS_PATH = "/planet/rss20.xml";
    private static final RestNamespace REST_NAMESPACE = new RestNamespace("ecf.rest.namespace", null);
    private static BundleContext context;
    private IContainer container;
    private ServiceTracker containerManagerServiceTracker;
    private IRemoteServiceRegistration registration;
    private IRemoteServiceClientContainerAdapter adapter;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        IContainerManager containerManager = this.getContainerManagerService();
        this.container = containerManager.getContainerFactory().createContainer(REST_CONTAINER_TYPE, this.getRestID(RSS_URL));
        this.adapter = this.getRestClientContainerAdapter();
        this.adapter.setResponseDeserializer((IRemoteResponseDeserializer)new SyndFeedResponseDeserializer());
        IRemoteService restClientService = this.adapter.getRemoteService(this.registerCall().getReference());
        this.asyncCall(restClientService);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        if (this.registration != null) {
            this.registration.unregister();
        }
        if (this.container != null) {
            this.container.disconnect();
        }
        if (this.containerManagerServiceTracker != null) {
            this.containerManagerServiceTracker.close();
        }
    }

    private void asyncCall(IRemoteService restClientService) {
        System.out.println("async calling...");
        restClientService.callAsync((IRemoteCall)this.getRestCall(), this.createRemoteCallListener());
        System.out.println("async called...");
    }

    private IRemoteServiceRegistration registerCall() {
        IRemoteCallable callable = RestCallableFactory.createCallable((String)RSS_PATH, (String)RSS_PATH, null, (AbstractRequestType)new HttpGetRequestType());
        this.registration = this.registerCallable(callable, null);
        return this.registration;
    }

    private void printFeedContent(SyndFeed feed) {
        System.out.println("Author: " + feed.getAuthor());
        System.out.println("Authors:");
        if (feed.getAuthors() != null) {
            for (Object author : feed.getAuthors()) {
                System.out.println(((SyndPerson)author).getName());
                System.out.println(((SyndPerson)author).getEmail());
                System.out.println(((SyndPerson)author).getUri());
                System.out.println();
            }
        }
        System.out.println("Title: " + feed.getTitle());
        System.out.println("Title Ex: " + feed.getTitleEx());
        System.out.println("Description: " + feed.getDescription());
        System.out.println("Description Ex: " + feed.getDescriptionEx());
        System.out.println("Date" + feed.getPublishedDate());
        System.out.println("Type: " + feed.getFeedType());
        System.out.println("Encoding: " + feed.getEncoding());
        System.out.println("(C) " + feed.getCopyright());
        System.out.println();
        for (Object object : feed.getEntries()) {
            SyndEntry entry = (SyndEntry)object;
            System.out.println(String.valueOf(entry.getTitle()) + " - " + entry.getAuthor());
            System.out.println(entry.getLink());
            for (Object contobj : entry.getContents()) {
                SyndContent content = (SyndContent)contobj;
                System.out.println(content.getType());
                System.out.println(content.getValue());
            }
            SyndContent content = entry.getDescription();
            if (content != null) {
                System.out.println(content.getValue());
            }
            System.out.println(entry.getPublishedDate());
            System.out.println();
        }
    }

    private IRemoteCallListener createRemoteCallListener() {
        return new IRemoteCallListener(){

            public void handleEvent(IRemoteCallEvent event) {
                if (event instanceof IRemoteCallCompleteEvent) {
                    IRemoteCallCompleteEvent cce = (IRemoteCallCompleteEvent)event;
                    if (!cce.hadException()) {
                        System.out.println("Remote call completed successfully!");
                        SyndFeed feed = (SyndFeed)cce.getResponse();
                        Activator.this.printFeedContent(feed);
                    } else {
                        System.out.println("Remote call completed with exception: " + cce.getException());
                    }
                }
            }
        };
    }

    private ID getRestID(String uri) {
        return IDFactory.getDefault().createID((Namespace)REST_NAMESPACE, uri);
    }

    private IRemoteServiceClientContainerAdapter getRestClientContainerAdapter() {
        return (IRemoteServiceClientContainerAdapter)this.container.getAdapter(IRemoteServiceClientContainerAdapter.class);
    }

    private IRemoteServiceRegistration registerCallable(IRemoteCallable callable, Dictionary<String, String> properties) {
        return this.adapter.registerCallables(new IRemoteCallable[]{callable}, properties);
    }

    private IRestCall getRestCall() {
        return RestCallFactory.createRestCall((String)RSS_PATH);
    }

    private IContainerManager getContainerManagerService() {
        if (this.containerManagerServiceTracker == null) {
            this.containerManagerServiceTracker = new ServiceTracker(context, IContainerManager.class.getName(), null);
            this.containerManagerServiceTracker.open();
        }
        return (IContainerManager)this.containerManagerServiceTracker.getService();
    }
}

