/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.ContainerIntentException;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.Activator;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.IDUtil;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.SelectContainerException;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;
import org.osgi.framework.ServiceReference;

public abstract class AbstractContainerSelector {
    public static final IRemoteServiceContainer[] EMPTY_REMOTE_SERVICE_CONTAINER_ARRAY = new IRemoteServiceContainer[0];

    protected IContainerManager getContainerManager() {
        return Activator.getDefault().getContainerManager();
    }

    protected IContainerFactory getContainerFactory() {
        return this.getContainerManager().getContainerFactory();
    }

    protected ContainerTypeDescription[] getContainerTypeDescriptions() {
        return this.getContainerFactory().getDescriptions().toArray(new ContainerTypeDescription[0]);
    }

    protected IContainer[] getContainers() {
        return this.getContainerManager().getAllContainers();
    }

    protected IRemoteServiceContainerAdapter hasRemoteServiceContainerAdapter(IContainer container) {
        return (IRemoteServiceContainerAdapter)container.getAdapter(IRemoteServiceContainerAdapter.class);
    }

    protected ContainerTypeDescription getContainerTypeDescription(IContainer container) {
        return this.getContainerManager().getContainerTypeDescription(container.getID());
    }

    protected IRemoteServiceContainer[] getRemoteServiceContainers(IContainer[] containers) {
        ArrayList<RemoteServiceContainer> results = new ArrayList<RemoteServiceContainer>();
        int i = 0;
        while (i < containers.length) {
            IRemoteServiceContainerAdapter adapter = this.hasRemoteServiceContainerAdapter(containers[i]);
            if (adapter != null) {
                results.add(new RemoteServiceContainer(containers[i], adapter));
            }
            ++i;
        }
        return results.toArray(new IRemoteServiceContainer[0]);
    }

    protected boolean includeContainerWithConnectNamespace(IContainer container, String connectNamespaceName) {
        Namespace namespace;
        return connectNamespaceName != null && (namespace = container.getConnectNamespace()) != null && namespace.getName().equals(connectNamespaceName);
    }

    protected void connectContainer(IContainer container, ID connectTargetID, IConnectContext connectContext) throws ContainerConnectException {
        this.trace("connectContainer", "Connecting container=" + String.valueOf(container.getID()) + " to connectTargetID=" + String.valueOf(connectTargetID));
        container.connect(connectTargetID, connectContext);
    }

    protected String[] getSupportedConfigTypes(ContainerTypeDescription containerTypeDescription) {
        String[] supportedConfigs = containerTypeDescription.getSupportedConfigs();
        return supportedConfigs == null ? new String[]{} : supportedConfigs;
    }

    protected String[] getSupportedIntents(ContainerTypeDescription containerTypeDescription) {
        String[] supportedIntents = containerTypeDescription.getSupportedIntents();
        return supportedIntents == null ? new String[]{} : supportedIntents;
    }

    protected IContainer createContainer(ServiceReference serviceReference, Map<String, Object> properties, ContainerTypeDescription containerTypeDescription) throws SelectContainerException {
        return this.createContainer(serviceReference, properties, containerTypeDescription, null);
    }

    protected IContainer createContainer(ServiceReference serviceReference, Map<String, Object> properties, ContainerTypeDescription containerTypeDescription, String[] intents) throws SelectContainerException {
        IContainerFactory containerFactory = this.getContainerFactory();
        Object containerFactoryArguments = this.getContainerFactoryArguments(serviceReference, properties, containerTypeDescription, intents);
        try {
            if (containerFactoryArguments instanceof String) {
                return containerFactory.createContainer(containerTypeDescription, (String)containerFactoryArguments);
            }
            if (containerFactoryArguments instanceof ID) {
                return containerFactory.createContainer(containerTypeDescription, (ID)containerFactoryArguments);
            }
            if (containerFactoryArguments instanceof Object[]) {
                return containerFactory.createContainer(containerTypeDescription, (Object[])containerFactoryArguments);
            }
            if (containerFactoryArguments instanceof Map) {
                return containerFactory.createContainer(containerTypeDescription, (Map)containerFactoryArguments);
            }
            return containerFactory.createContainer(containerTypeDescription);
        }
        catch (ContainerCreateException e) {
            if (e instanceof ContainerIntentException) {
                LogUtility.logError("createContainer", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/containerselector", this.getClass(), "Container creation does not satisfy required intent=" + ((ContainerIntentException)e).getIntentName(), e);
                return null;
            }
            throw new SelectContainerException("Exception creating or configuring container", e, containerTypeDescription);
        }
    }

    protected Object getContainerFactoryArguments(ServiceReference serviceReference, Map<String, Object> properties, ContainerTypeDescription containerTypeDescription) {
        return this.getContainerFactoryArguments(serviceReference, properties, containerTypeDescription, null);
    }

    protected Object getContainerFactoryArguments(ServiceReference serviceReference, Map<String, Object> properties, ContainerTypeDescription containerTypeDescription, String[] intents) {
        String exportedConfig;
        Map<String, Object> configProperties;
        Object containerFactoryArguments = properties.get("ecf.exported.containerfactoryargs");
        if (containerFactoryArguments != null) {
            return containerFactoryArguments;
        }
        Map<String, Object> results = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (intents != null) {
            results.put("service.intents", intents);
        }
        if (intents != null) {
            String[] stringArray = serviceReference.getPropertyKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String propName = stringArray[n2];
                Object value = null;
                String[] stringArray2 = intents;
                int n3 = intents.length;
                int n4 = 0;
                while (n4 < n3) {
                    String intent = stringArray2[n4];
                    if (propName.startsWith(intent + ".")) {
                        value = serviceReference.getProperty(propName);
                    }
                    ++n4;
                }
                if (value != null) {
                    results.put(propName, value);
                }
                ++n2;
            }
        }
        if (intents != null) {
            for (String propName : properties.keySet()) {
                Object value = null;
                String[] stringArray = intents;
                int n = intents.length;
                int n5 = 0;
                while (n5 < n) {
                    String intent = stringArray[n5];
                    if (propName.startsWith(intent + ".")) {
                        value = properties.get(propName);
                    }
                    ++n5;
                }
                if (value == null) continue;
                results.put(propName, value);
            }
        }
        if ((results = PropertiesUtil.mergeProperties(results, configProperties = PropertiesUtil.getConfigProperties(exportedConfig = containerTypeDescription.getName(), properties))).size() == 0) {
            return null;
        }
        return results;
    }

    protected ID createTargetID(IContainer container, String target) {
        return IDUtil.createID(container.getConnectNamespace(), target);
    }

    protected void disconnectContainer(IContainer container) {
        container.disconnect();
    }

    protected IConnectContext createConnectContext(ServiceReference serviceReference, Map<String, Object> properties, IContainer container, Object context) {
        if (context instanceof IConnectContext) {
            return (IConnectContext)context;
        }
        return null;
    }

    protected void logException(String string, Exception e) {
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.osgi.services.remoteserviceadmin", string, (Throwable)e));
    }

    protected void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/containerselector", this.getClass(), message);
    }

    protected void traceException(String methodName, String message, Throwable t) {
        LogUtility.traceException(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/exceptions/catching", this.getClass(), message, t);
    }

    protected void logError(String methodName, String message, Throwable t) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/containerselector", this.getClass(), message, t);
    }

    protected void logError(String methodName, String message) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/containerselector", this.getClass(), message);
    }

    protected void logWarning(String methodName, String message) {
        LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/containerselector", this.getClass(), message);
    }

    protected boolean matchConnectNamespace(IContainer container, ID endpointID, ID connectTargetID) {
        if (connectTargetID != null) {
            return connectTargetID.getNamespace().getName().equals(container.getConnectNamespace().getName());
        }
        if (endpointID == null) {
            return false;
        }
        return endpointID.getNamespace().getName().equals(container.getConnectNamespace().getName());
    }

    protected boolean matchContainerID(IContainer container, ID endpointID) {
        if (endpointID == null) {
            return false;
        }
        return endpointID.equals((Object)container.getID());
    }
}

