/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractMetadataFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IServiceInfoFactory;

public class ServiceInfoFactory
extends AbstractMetadataFactory
implements IServiceInfoFactory {
    private final List<String> discoveryProperties = Arrays.asList("osgirsvc_", "ecf.endpoint.discovery.namingauthority", "ecf.endpoint.discovery.protocols", "ecf.endpoint.discovery.scope", "ecf.endpoint.discovery.servicename", "ecf.endpoint.discovery.priority", "ecf.endpoint.discovery.ttl", "ecfosgirsvc", "ecf.endpoint.discovery.weight");

    @Override
    public IServiceInfo createServiceInfo(IDiscoveryAdvertiser advertiser, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        try {
            IServiceTypeID serviceTypeID = this.createServiceTypeID(endpointDescription, advertiser);
            String serviceName = this.createServiceName(endpointDescription, advertiser, serviceTypeID);
            URI uri = this.createURI(endpointDescription, advertiser, serviceTypeID, serviceName);
            IServiceProperties serviceProperties = this.createServiceProperties(endpointDescription, advertiser, serviceTypeID, serviceName, uri);
            Map edProperties = endpointDescription.getProperties();
            int priority = PropertiesUtil.getIntWithDefault(edProperties, "ecf.endpoint.discovery.priority", 0);
            int weight = PropertiesUtil.getIntWithDefault(edProperties, "ecf.endpoint.discovery.weight", 0);
            Long ttl = PropertiesUtil.getLongWithDefault(edProperties, "ecf.endpoint.discovery.ttl", 3600L);
            return new ServiceInfo(uri, serviceName, serviceTypeID, priority, weight, serviceProperties, ttl.longValue());
        }
        catch (Exception e) {
            this.logError("createServiceInfo", "Exception creating service info for endpointDescription=" + String.valueOf(endpointDescription) + ",advertiser=" + String.valueOf(advertiser), e);
            return null;
        }
    }

    protected IServiceInfo createServiceInfo(URI uri, String serviceName, IServiceTypeID serviceTypeID, IServiceProperties serviceProperties) {
        return new ServiceInfo(uri, serviceName, serviceTypeID, serviceProperties);
    }

    protected IServiceProperties createServiceProperties(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, IDiscoveryAdvertiser advertiser, IServiceTypeID serviceTypeID, String serviceName, URI uri) {
        Map props = endpointDescription.getProperties();
        TreeMap<String, Object> result = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (String key : props.keySet()) {
            if (this.discoveryProperties.contains(key)) continue;
            result.put(key, props.get(key));
        }
        ServiceProperties spResult = new ServiceProperties();
        this.encodeServiceProperties(new EndpointDescription(result), (IServiceProperties)spResult);
        return spResult;
    }

    protected URI createURI(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, IDiscoveryAdvertiser advertiser, IServiceTypeID serviceTypeID, String serviceName) throws URISyntaxException {
        String path = "/" + serviceName;
        String str = endpointDescription.getId();
        URI uri = null;
        try {
            while ((uri = new URI(str)).getHost() == null) {
                String rawSchemeSpecificPart = uri.getRawSchemeSpecificPart();
                if (str.equals(rawSchemeSpecificPart)) {
                    uri = null;
                    break;
                }
                str = rawSchemeSpecificPart;
            }
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        String scheme = "ecfosgirsvc";
        int port = 32565;
        if (uri != null && (port = uri.getPort()) == -1) {
            port = 32565;
        }
        String host = null;
        if (uri != null) {
            host = uri.getHost();
        } else {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                this.logWarning("createURI", "failed to get local host adress, falling back to 'localhost'.", e);
                host = "localhost";
            }
        }
        return new URI(scheme, null, host, port, path, null, null);
    }

    protected String createServiceName(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, IDiscoveryAdvertiser advertiser, IServiceTypeID serviceTypeID) {
        String defaultServiceName = this.createDefaultServiceName(endpointDescription, advertiser, serviceTypeID);
        String serviceName = PropertiesUtil.getStringWithDefault(endpointDescription.getProperties(), "ecf.endpoint.discovery.servicename", defaultServiceName);
        return serviceName;
    }

    protected String createDefaultServiceName(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, IDiscoveryAdvertiser advertiser, IServiceTypeID serviceTypeID) {
        return "osgirsvc_" + IDFactory.getDefault().createGUID().getName();
    }

    protected IServiceTypeID createServiceTypeID(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, IDiscoveryAdvertiser advertiser) {
        Namespace servicesNamespace = IDFactory.getDefault().getNamespaceByName("ecf.namespace.discovery");
        if (advertiser != null) {
            servicesNamespace = advertiser.getServicesNamespace();
        }
        Map props = endpointDescription.getProperties();
        String[] scopes = PropertiesUtil.getStringArrayWithDefault(props, "ecf.endpoint.discovery.scope", IServiceTypeID.DEFAULT_SCOPE);
        String[] protocols = PropertiesUtil.getStringArrayWithDefault(props, "ecf.endpoint.discovery.protocols", IServiceTypeID.DEFAULT_SCOPE);
        String namingAuthority = PropertiesUtil.getStringWithDefault(props, "ecf.endpoint.discovery.namingauthority", "iana");
        return ServiceIDFactory.getDefault().createServiceTypeID(servicesNamespace, new String[]{"ecfosgirsvc"}, scopes, protocols, namingAuthority);
    }
}

